/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.AccessProfile;
import java.io.IOException;
import java.util.Map;

public final class ManagedClusterAccessProfileInner
extends Resource {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private AccessProfile innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterAccessProfileInner.class);

    private AccessProfile innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ManagedClusterAccessProfileInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ManagedClusterAccessProfileInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public byte[] kubeConfig() {
        return this.innerProperties() == null ? EMPTY_BYTE_ARRAY : this.innerProperties().kubeConfig();
    }

    public ManagedClusterAccessProfileInner withKubeConfig(byte[] kubeConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AccessProfile();
        }
        this.innerProperties().withKubeConfig(kubeConfig);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model ManagedClusterAccessProfileInner"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterAccessProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterAccessProfileInner)((Object)jsonReader.readObject(reader -> {
            ManagedClusterAccessProfileInner deserializedManagedClusterAccessProfileInner = new ManagedClusterAccessProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedClusterAccessProfileInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedClusterAccessProfileInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedClusterAccessProfileInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedManagedClusterAccessProfileInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedClusterAccessProfileInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedClusterAccessProfileInner.innerProperties = AccessProfile.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedManagedClusterAccessProfileInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterAccessProfileInner;
        }));
    }
}

