// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Profile for enabling a user to access a managed cluster.
 */
@Fluent
public final class AccessProfile implements JsonSerializable<AccessProfile> {
    /*
     * Base64-encoded Kubernetes configuration file.
     */
    private byte[] kubeConfig;

    /**
     * Creates an instance of AccessProfile class.
     */
    public AccessProfile() {
    }

    /**
     * Get the kubeConfig property: Base64-encoded Kubernetes configuration file.
     * 
     * @return the kubeConfig value.
     */
    public byte[] kubeConfig() {
        return CoreUtils.clone(this.kubeConfig);
    }

    /**
     * Set the kubeConfig property: Base64-encoded Kubernetes configuration file.
     * 
     * @param kubeConfig the kubeConfig value to set.
     * @return the AccessProfile object itself.
     */
    public AccessProfile withKubeConfig(byte[] kubeConfig) {
        this.kubeConfig = CoreUtils.clone(kubeConfig);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBinaryField("kubeConfig", this.kubeConfig);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AccessProfile.
     */
    public static AccessProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessProfile deserializedAccessProfile = new AccessProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kubeConfig".equals(fieldName)) {
                    deserializedAccessProfile.kubeConfig = reader.getBinary();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessProfile;
        });
    }
}
