// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.AgentPoolMode;
import com.azure.resourcemanager.containerservice.models.AgentPoolNetworkProfile;
import com.azure.resourcemanager.containerservice.models.AgentPoolSecurityProfile;
import com.azure.resourcemanager.containerservice.models.AgentPoolType;
import com.azure.resourcemanager.containerservice.models.AgentPoolUpgradeSettings;
import com.azure.resourcemanager.containerservice.models.AgentPoolWindowsProfile;
import com.azure.resourcemanager.containerservice.models.CreationData;
import com.azure.resourcemanager.containerservice.models.GpuInstanceProfile;
import com.azure.resourcemanager.containerservice.models.KubeletConfig;
import com.azure.resourcemanager.containerservice.models.KubeletDiskType;
import com.azure.resourcemanager.containerservice.models.LinuxOSConfig;
import com.azure.resourcemanager.containerservice.models.OSDiskType;
import com.azure.resourcemanager.containerservice.models.OSSku;
import com.azure.resourcemanager.containerservice.models.OSType;
import com.azure.resourcemanager.containerservice.models.PowerState;
import com.azure.resourcemanager.containerservice.models.ScaleDownMode;
import com.azure.resourcemanager.containerservice.models.ScaleSetEvictionPolicy;
import com.azure.resourcemanager.containerservice.models.ScaleSetPriority;
import com.azure.resourcemanager.containerservice.models.WorkloadRuntime;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Agent Pool.
 */
@Fluent
public final class AgentPoolInner extends SubResource {
    /*
     * Properties of an agent pool.
     */
    private ManagedClusterAgentPoolProfileProperties innerProperties;

    /*
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    private String name;

    /*
     * Resource type
     */
    private String type;

    /**
     * Creates an instance of AgentPoolInner class.
     */
    public AgentPoolInner() {
    }

    /**
     * Get the innerProperties property: Properties of an agent pool.
     * 
     * @return the innerProperties value.
     */
    private ManagedClusterAgentPoolProfileProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AgentPoolInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the etag property: Unique read-only string used to implement optimistic concurrency. The eTag value will
     * change when the resource is updated. Specify an if-match or if-none-match header with the eTag value for a
     * subsequent request to enable optimistic concurrency per the normal etag convention.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.innerProperties() == null ? null : this.innerProperties().etag();
    }

    /**
     * Get the count property: Number of agents (VMs) to host docker containers. Allowed values must be in the range of
     * 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default
     * value is 1.
     * 
     * @return the count value.
     */
    public Integer count() {
        return this.innerProperties() == null ? null : this.innerProperties().count();
    }

    /**
     * Set the count property: Number of agents (VMs) to host docker containers. Allowed values must be in the range of
     * 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default
     * value is 1.
     * 
     * @param count the count value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withCount(Integer count) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withCount(count);
        return this;
    }

    /**
     * Get the vmSize property: VM size availability varies by region. If a node contains insufficient compute resources
     * (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see:
     * https://docs.microsoft.com/azure/aks/quotas-skus-regions.
     * 
     * @return the vmSize value.
     */
    public String vmSize() {
        return this.innerProperties() == null ? null : this.innerProperties().vmSize();
    }

    /**
     * Set the vmSize property: VM size availability varies by region. If a node contains insufficient compute resources
     * (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see:
     * https://docs.microsoft.com/azure/aks/quotas-skus-regions.
     * 
     * @param vmSize the vmSize value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withVmSize(String vmSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withVmSize(vmSize);
        return this;
    }

    /**
     * Get the osDiskSizeGB property: OS Disk Size in GB to be used to specify the disk size for every machine in the
     * master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
     * 
     * @return the osDiskSizeGB value.
     */
    public Integer osDiskSizeGB() {
        return this.innerProperties() == null ? null : this.innerProperties().osDiskSizeGB();
    }

    /**
     * Set the osDiskSizeGB property: OS Disk Size in GB to be used to specify the disk size for every machine in the
     * master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
     * 
     * @param osDiskSizeGB the osDiskSizeGB value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withOsDiskSizeGB(Integer osDiskSizeGB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withOsDiskSizeGB(osDiskSizeGB);
        return this;
    }

    /**
     * Get the osDiskType property: The default is 'Ephemeral' if the VM supports it and has a cache disk larger than
     * the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more
     * information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
     * 
     * @return the osDiskType value.
     */
    public OSDiskType osDiskType() {
        return this.innerProperties() == null ? null : this.innerProperties().osDiskType();
    }

    /**
     * Set the osDiskType property: The default is 'Ephemeral' if the VM supports it and has a cache disk larger than
     * the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more
     * information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
     * 
     * @param osDiskType the osDiskType value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withOsDiskType(OSDiskType osDiskType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withOsDiskType(osDiskType);
        return this;
    }

    /**
     * Get the kubeletDiskType property: Determines the placement of emptyDir volumes, container runtime data root, and
     * Kubelet ephemeral storage.
     * 
     * @return the kubeletDiskType value.
     */
    public KubeletDiskType kubeletDiskType() {
        return this.innerProperties() == null ? null : this.innerProperties().kubeletDiskType();
    }

    /**
     * Set the kubeletDiskType property: Determines the placement of emptyDir volumes, container runtime data root, and
     * Kubelet ephemeral storage.
     * 
     * @param kubeletDiskType the kubeletDiskType value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withKubeletDiskType(KubeletDiskType kubeletDiskType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withKubeletDiskType(kubeletDiskType);
        return this;
    }

    /**
     * Get the workloadRuntime property: Determines the type of workload a node can run.
     * 
     * @return the workloadRuntime value.
     */
    public WorkloadRuntime workloadRuntime() {
        return this.innerProperties() == null ? null : this.innerProperties().workloadRuntime();
    }

    /**
     * Set the workloadRuntime property: Determines the type of workload a node can run.
     * 
     * @param workloadRuntime the workloadRuntime value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withWorkloadRuntime(WorkloadRuntime workloadRuntime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withWorkloadRuntime(workloadRuntime);
        return this;
    }

    /**
     * Get the vnetSubnetId property: If this is not specified, a VNET and subnet will be generated and used. If no
     * podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the
     * form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @return the vnetSubnetId value.
     */
    public String vnetSubnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().vnetSubnetId();
    }

    /**
     * Set the vnetSubnetId property: If this is not specified, a VNET and subnet will be generated and used. If no
     * podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the
     * form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @param vnetSubnetId the vnetSubnetId value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withVnetSubnetId(String vnetSubnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withVnetSubnetId(vnetSubnetId);
        return this;
    }

    /**
     * Get the podSubnetId property: If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID
     * for more details). This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @return the podSubnetId value.
     */
    public String podSubnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().podSubnetId();
    }

    /**
     * Set the podSubnetId property: If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID
     * for more details). This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
     * 
     * @param podSubnetId the podSubnetId value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withPodSubnetId(String podSubnetId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withPodSubnetId(podSubnetId);
        return this;
    }

    /**
     * Get the maxPods property: The maximum number of pods that can run on a node.
     * 
     * @return the maxPods value.
     */
    public Integer maxPods() {
        return this.innerProperties() == null ? null : this.innerProperties().maxPods();
    }

    /**
     * Set the maxPods property: The maximum number of pods that can run on a node.
     * 
     * @param maxPods the maxPods value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withMaxPods(Integer maxPods) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withMaxPods(maxPods);
        return this;
    }

    /**
     * Get the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @return the osType value.
     */
    public OSType osType() {
        return this.innerProperties() == null ? null : this.innerProperties().osType();
    }

    /**
     * Set the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @param osType the osType value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withOsType(OSType osType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withOsType(osType);
        return this;
    }

    /**
     * Get the osSku property: Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux.
     * The default is Windows2019 when Kubernetes &lt;= 1.24 or Windows2022 when Kubernetes &gt;= 1.25 if OSType is
     * Windows.
     * 
     * @return the osSku value.
     */
    public OSSku osSku() {
        return this.innerProperties() == null ? null : this.innerProperties().osSku();
    }

    /**
     * Set the osSku property: Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux.
     * The default is Windows2019 when Kubernetes &lt;= 1.24 or Windows2022 when Kubernetes &gt;= 1.25 if OSType is
     * Windows.
     * 
     * @param osSku the osSku value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withOsSku(OSSku osSku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withOsSku(osSku);
        return this;
    }

    /**
     * Get the maxCount property: The maximum number of nodes for auto-scaling.
     * 
     * @return the maxCount value.
     */
    public Integer maxCount() {
        return this.innerProperties() == null ? null : this.innerProperties().maxCount();
    }

    /**
     * Set the maxCount property: The maximum number of nodes for auto-scaling.
     * 
     * @param maxCount the maxCount value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withMaxCount(Integer maxCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withMaxCount(maxCount);
        return this;
    }

    /**
     * Get the minCount property: The minimum number of nodes for auto-scaling.
     * 
     * @return the minCount value.
     */
    public Integer minCount() {
        return this.innerProperties() == null ? null : this.innerProperties().minCount();
    }

    /**
     * Set the minCount property: The minimum number of nodes for auto-scaling.
     * 
     * @param minCount the minCount value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withMinCount(Integer minCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withMinCount(minCount);
        return this;
    }

    /**
     * Get the enableAutoScaling property: Whether to enable auto-scaler.
     * 
     * @return the enableAutoScaling value.
     */
    public Boolean enableAutoScaling() {
        return this.innerProperties() == null ? null : this.innerProperties().enableAutoScaling();
    }

    /**
     * Set the enableAutoScaling property: Whether to enable auto-scaler.
     * 
     * @param enableAutoScaling the enableAutoScaling value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withEnableAutoScaling(Boolean enableAutoScaling) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withEnableAutoScaling(enableAutoScaling);
        return this;
    }

    /**
     * Get the scaleDownMode property: This also effects the cluster autoscaler behavior. If not specified, it defaults
     * to Delete.
     * 
     * @return the scaleDownMode value.
     */
    public ScaleDownMode scaleDownMode() {
        return this.innerProperties() == null ? null : this.innerProperties().scaleDownMode();
    }

    /**
     * Set the scaleDownMode property: This also effects the cluster autoscaler behavior. If not specified, it defaults
     * to Delete.
     * 
     * @param scaleDownMode the scaleDownMode value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withScaleDownMode(ScaleDownMode scaleDownMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withScaleDownMode(scaleDownMode);
        return this;
    }

    /**
     * Get the type property: The type of Agent Pool.
     * 
     * @return the type value.
     */
    public AgentPoolType typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Set the type property: The type of Agent Pool.
     * 
     * @param type the type value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withTypePropertiesType(AgentPoolType type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withType(type);
        return this;
    }

    /**
     * Get the mode property: A cluster must have at least one 'System' Agent Pool at all times. For additional
     * information on agent pool restrictions and best practices, see:
     * https://docs.microsoft.com/azure/aks/use-system-pools.
     * 
     * @return the mode value.
     */
    public AgentPoolMode mode() {
        return this.innerProperties() == null ? null : this.innerProperties().mode();
    }

    /**
     * Set the mode property: A cluster must have at least one 'System' Agent Pool at all times. For additional
     * information on agent pool restrictions and best practices, see:
     * https://docs.microsoft.com/azure/aks/use-system-pools.
     * 
     * @param mode the mode value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withMode(AgentPoolMode mode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withMode(mode);
        return this;
    }

    /**
     * Get the orchestratorVersion property: Both patch version &lt;major.minor.patch&gt; (e.g. 1.20.13) and
     * &lt;major.minor&gt; (e.g. 1.20) are supported. When &lt;major.minor&gt; is specified, the latest supported GA
     * patch version is chosen automatically. Updating the cluster with the same &lt;major.minor&gt; once it has been
     * created (e.g. 1.14.x -&gt; 1.14) will not trigger an upgrade, even if a newer patch version is available. As a
     * best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool
     * version must have the same major version as the control plane. The node pool minor version must be within two
     * minor versions of the control plane version. The node pool version cannot be greater than the control plane
     * version. For more information see [upgrading a node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
     * 
     * @return the orchestratorVersion value.
     */
    public String orchestratorVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().orchestratorVersion();
    }

    /**
     * Set the orchestratorVersion property: Both patch version &lt;major.minor.patch&gt; (e.g. 1.20.13) and
     * &lt;major.minor&gt; (e.g. 1.20) are supported. When &lt;major.minor&gt; is specified, the latest supported GA
     * patch version is chosen automatically. Updating the cluster with the same &lt;major.minor&gt; once it has been
     * created (e.g. 1.14.x -&gt; 1.14) will not trigger an upgrade, even if a newer patch version is available. As a
     * best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool
     * version must have the same major version as the control plane. The node pool minor version must be within two
     * minor versions of the control plane version. The node pool version cannot be greater than the control plane
     * version. For more information see [upgrading a node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
     * 
     * @param orchestratorVersion the orchestratorVersion value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withOrchestratorVersion(String orchestratorVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withOrchestratorVersion(orchestratorVersion);
        return this;
    }

    /**
     * Get the currentOrchestratorVersion property: If orchestratorVersion is a fully specified version
     * &lt;major.minor.patch&gt;, this field will be exactly equal to it. If orchestratorVersion is &lt;major.minor&gt;,
     * this field will contain the full &lt;major.minor.patch&gt; version being used.
     * 
     * @return the currentOrchestratorVersion value.
     */
    public String currentOrchestratorVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().currentOrchestratorVersion();
    }

    /**
     * Get the nodeImageVersion property: The version of node image.
     * 
     * @return the nodeImageVersion value.
     */
    public String nodeImageVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().nodeImageVersion();
    }

    /**
     * Get the upgradeSettings property: Settings for upgrading the agentpool.
     * 
     * @return the upgradeSettings value.
     */
    public AgentPoolUpgradeSettings upgradeSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradeSettings();
    }

    /**
     * Set the upgradeSettings property: Settings for upgrading the agentpool.
     * 
     * @param upgradeSettings the upgradeSettings value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withUpgradeSettings(AgentPoolUpgradeSettings upgradeSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withUpgradeSettings(upgradeSettings);
        return this;
    }

    /**
     * Get the provisioningState property: The current deployment or provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the powerState property: When an Agent Pool is first created it is initially Running. The Agent Pool can be
     * stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing
     * charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded.
     * 
     * @return the powerState value.
     */
    public PowerState powerState() {
        return this.innerProperties() == null ? null : this.innerProperties().powerState();
    }

    /**
     * Set the powerState property: When an Agent Pool is first created it is initially Running. The Agent Pool can be
     * stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing
     * charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded.
     * 
     * @param powerState the powerState value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withPowerState(PowerState powerState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withPowerState(powerState);
        return this;
    }

    /**
     * Get the availabilityZones property: The list of Availability zones to use for nodes. This can only be specified
     * if the AgentPoolType property is 'VirtualMachineScaleSets'.
     * 
     * @return the availabilityZones value.
     */
    public List<String> availabilityZones() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilityZones();
    }

    /**
     * Set the availabilityZones property: The list of Availability zones to use for nodes. This can only be specified
     * if the AgentPoolType property is 'VirtualMachineScaleSets'.
     * 
     * @param availabilityZones the availabilityZones value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withAvailabilityZones(List<String> availabilityZones) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withAvailabilityZones(availabilityZones);
        return this;
    }

    /**
     * Get the enableNodePublicIp property: Some scenarios may require nodes in a node pool to receive their own
     * dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct
     * connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per
     * node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools).
     * The default is false.
     * 
     * @return the enableNodePublicIp value.
     */
    public Boolean enableNodePublicIp() {
        return this.innerProperties() == null ? null : this.innerProperties().enableNodePublicIp();
    }

    /**
     * Set the enableNodePublicIp property: Some scenarios may require nodes in a node pool to receive their own
     * dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct
     * connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per
     * node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools).
     * The default is false.
     * 
     * @param enableNodePublicIp the enableNodePublicIp value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withEnableNodePublicIp(Boolean enableNodePublicIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withEnableNodePublicIp(enableNodePublicIp);
        return this;
    }

    /**
     * Get the nodePublicIpPrefixId property: This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.
     * 
     * @return the nodePublicIpPrefixId value.
     */
    public String nodePublicIpPrefixId() {
        return this.innerProperties() == null ? null : this.innerProperties().nodePublicIpPrefixId();
    }

    /**
     * Set the nodePublicIpPrefixId property: This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}.
     * 
     * @param nodePublicIpPrefixId the nodePublicIpPrefixId value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withNodePublicIpPrefixId(String nodePublicIpPrefixId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withNodePublicIpPrefixId(nodePublicIpPrefixId);
        return this;
    }

    /**
     * Get the scaleSetPriority property: The Virtual Machine Scale Set priority. If not specified, the default is
     * 'Regular'.
     * 
     * @return the scaleSetPriority value.
     */
    public ScaleSetPriority scaleSetPriority() {
        return this.innerProperties() == null ? null : this.innerProperties().scaleSetPriority();
    }

    /**
     * Set the scaleSetPriority property: The Virtual Machine Scale Set priority. If not specified, the default is
     * 'Regular'.
     * 
     * @param scaleSetPriority the scaleSetPriority value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withScaleSetPriority(ScaleSetPriority scaleSetPriority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withScaleSetPriority(scaleSetPriority);
        return this;
    }

    /**
     * Get the scaleSetEvictionPolicy property: This cannot be specified unless the scaleSetPriority is 'Spot'. If not
     * specified, the default is 'Delete'.
     * 
     * @return the scaleSetEvictionPolicy value.
     */
    public ScaleSetEvictionPolicy scaleSetEvictionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().scaleSetEvictionPolicy();
    }

    /**
     * Set the scaleSetEvictionPolicy property: This cannot be specified unless the scaleSetPriority is 'Spot'. If not
     * specified, the default is 'Delete'.
     * 
     * @param scaleSetEvictionPolicy the scaleSetEvictionPolicy value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withScaleSetEvictionPolicy(ScaleSetEvictionPolicy scaleSetEvictionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withScaleSetEvictionPolicy(scaleSetEvictionPolicy);
        return this;
    }

    /**
     * Get the spotMaxPrice property: Possible values are any decimal value greater than zero or -1 which indicates the
     * willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs
     * pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing).
     * 
     * @return the spotMaxPrice value.
     */
    public Float spotMaxPrice() {
        return this.innerProperties() == null ? null : this.innerProperties().spotMaxPrice();
    }

    /**
     * Set the spotMaxPrice property: Possible values are any decimal value greater than zero or -1 which indicates the
     * willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs
     * pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing).
     * 
     * @param spotMaxPrice the spotMaxPrice value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withSpotMaxPrice(Float spotMaxPrice) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withSpotMaxPrice(spotMaxPrice);
        return this;
    }

    /**
     * Get the tags property: The tags to be persisted on the agent pool virtual machine scale set.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    /**
     * Set the tags property: The tags to be persisted on the agent pool virtual machine scale set.
     * 
     * @param tags the tags value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withTags(Map<String, String> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withTags(tags);
        return this;
    }

    /**
     * Get the nodeLabels property: The node labels to be persisted across all nodes in agent pool.
     * 
     * @return the nodeLabels value.
     */
    public Map<String, String> nodeLabels() {
        return this.innerProperties() == null ? null : this.innerProperties().nodeLabels();
    }

    /**
     * Set the nodeLabels property: The node labels to be persisted across all nodes in agent pool.
     * 
     * @param nodeLabels the nodeLabels value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withNodeLabels(Map<String, String> nodeLabels) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withNodeLabels(nodeLabels);
        return this;
    }

    /**
     * Get the nodeTaints property: The taints added to new nodes during node pool create and scale. For example,
     * key=value:NoSchedule.
     * 
     * @return the nodeTaints value.
     */
    public List<String> nodeTaints() {
        return this.innerProperties() == null ? null : this.innerProperties().nodeTaints();
    }

    /**
     * Set the nodeTaints property: The taints added to new nodes during node pool create and scale. For example,
     * key=value:NoSchedule.
     * 
     * @param nodeTaints the nodeTaints value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withNodeTaints(List<String> nodeTaints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withNodeTaints(nodeTaints);
        return this;
    }

    /**
     * Get the proximityPlacementGroupId property: The ID for Proximity Placement Group.
     * 
     * @return the proximityPlacementGroupId value.
     */
    public String proximityPlacementGroupId() {
        return this.innerProperties() == null ? null : this.innerProperties().proximityPlacementGroupId();
    }

    /**
     * Set the proximityPlacementGroupId property: The ID for Proximity Placement Group.
     * 
     * @param proximityPlacementGroupId the proximityPlacementGroupId value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withProximityPlacementGroupId(String proximityPlacementGroupId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withProximityPlacementGroupId(proximityPlacementGroupId);
        return this;
    }

    /**
     * Get the kubeletConfig property: The Kubelet configuration on the agent pool nodes.
     * 
     * @return the kubeletConfig value.
     */
    public KubeletConfig kubeletConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().kubeletConfig();
    }

    /**
     * Set the kubeletConfig property: The Kubelet configuration on the agent pool nodes.
     * 
     * @param kubeletConfig the kubeletConfig value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withKubeletConfig(KubeletConfig kubeletConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withKubeletConfig(kubeletConfig);
        return this;
    }

    /**
     * Get the linuxOSConfig property: The OS configuration of Linux agent nodes.
     * 
     * @return the linuxOSConfig value.
     */
    public LinuxOSConfig linuxOSConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().linuxOSConfig();
    }

    /**
     * Set the linuxOSConfig property: The OS configuration of Linux agent nodes.
     * 
     * @param linuxOSConfig the linuxOSConfig value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withLinuxOSConfig(LinuxOSConfig linuxOSConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withLinuxOSConfig(linuxOSConfig);
        return this;
    }

    /**
     * Get the enableEncryptionAtHost property: This is only supported on certain VM sizes and in certain Azure regions.
     * For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption.
     * 
     * @return the enableEncryptionAtHost value.
     */
    public Boolean enableEncryptionAtHost() {
        return this.innerProperties() == null ? null : this.innerProperties().enableEncryptionAtHost();
    }

    /**
     * Set the enableEncryptionAtHost property: This is only supported on certain VM sizes and in certain Azure regions.
     * For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption.
     * 
     * @param enableEncryptionAtHost the enableEncryptionAtHost value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withEnableEncryptionAtHost(Boolean enableEncryptionAtHost) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withEnableEncryptionAtHost(enableEncryptionAtHost);
        return this;
    }

    /**
     * Get the enableUltraSsd property: Whether to enable UltraSSD.
     * 
     * @return the enableUltraSsd value.
     */
    public Boolean enableUltraSsd() {
        return this.innerProperties() == null ? null : this.innerProperties().enableUltraSsd();
    }

    /**
     * Set the enableUltraSsd property: Whether to enable UltraSSD.
     * 
     * @param enableUltraSsd the enableUltraSsd value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withEnableUltraSsd(Boolean enableUltraSsd) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withEnableUltraSsd(enableUltraSsd);
        return this;
    }

    /**
     * Get the enableFips property: See [Add a FIPS-enabled node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more
     * details.
     * 
     * @return the enableFips value.
     */
    public Boolean enableFips() {
        return this.innerProperties() == null ? null : this.innerProperties().enableFips();
    }

    /**
     * Set the enableFips property: See [Add a FIPS-enabled node
     * pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more
     * details.
     * 
     * @param enableFips the enableFips value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withEnableFips(Boolean enableFips) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withEnableFips(enableFips);
        return this;
    }

    /**
     * Get the gpuInstanceProfile property: GPUInstanceProfile to be used to specify GPU MIG instance profile for
     * supported GPU VM SKU.
     * 
     * @return the gpuInstanceProfile value.
     */
    public GpuInstanceProfile gpuInstanceProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().gpuInstanceProfile();
    }

    /**
     * Set the gpuInstanceProfile property: GPUInstanceProfile to be used to specify GPU MIG instance profile for
     * supported GPU VM SKU.
     * 
     * @param gpuInstanceProfile the gpuInstanceProfile value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withGpuInstanceProfile(GpuInstanceProfile gpuInstanceProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withGpuInstanceProfile(gpuInstanceProfile);
        return this;
    }

    /**
     * Get the creationData property: CreationData to be used to specify the source Snapshot ID if the node pool will be
     * created/upgraded using a snapshot.
     * 
     * @return the creationData value.
     */
    public CreationData creationData() {
        return this.innerProperties() == null ? null : this.innerProperties().creationData();
    }

    /**
     * Set the creationData property: CreationData to be used to specify the source Snapshot ID if the node pool will be
     * created/upgraded using a snapshot.
     * 
     * @param creationData the creationData value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withCreationData(CreationData creationData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withCreationData(creationData);
        return this;
    }

    /**
     * Get the capacityReservationGroupId property: AKS will associate the specified agent pool with the Capacity
     * Reservation Group.
     * 
     * @return the capacityReservationGroupId value.
     */
    public String capacityReservationGroupId() {
        return this.innerProperties() == null ? null : this.innerProperties().capacityReservationGroupId();
    }

    /**
     * Set the capacityReservationGroupId property: AKS will associate the specified agent pool with the Capacity
     * Reservation Group.
     * 
     * @param capacityReservationGroupId the capacityReservationGroupId value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withCapacityReservationGroupId(String capacityReservationGroupId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withCapacityReservationGroupId(capacityReservationGroupId);
        return this;
    }

    /**
     * Get the hostGroupId property: This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.
     * For more information see [Azure dedicated
     * hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
     * 
     * @return the hostGroupId value.
     */
    public String hostGroupId() {
        return this.innerProperties() == null ? null : this.innerProperties().hostGroupId();
    }

    /**
     * Set the hostGroupId property: This is of the form:
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}.
     * For more information see [Azure dedicated
     * hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
     * 
     * @param hostGroupId the hostGroupId value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withHostGroupId(String hostGroupId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withHostGroupId(hostGroupId);
        return this;
    }

    /**
     * Get the networkProfile property: Network-related settings of an agent pool.
     * 
     * @return the networkProfile value.
     */
    public AgentPoolNetworkProfile networkProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().networkProfile();
    }

    /**
     * Set the networkProfile property: Network-related settings of an agent pool.
     * 
     * @param networkProfile the networkProfile value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withNetworkProfile(AgentPoolNetworkProfile networkProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withNetworkProfile(networkProfile);
        return this;
    }

    /**
     * Get the windowsProfile property: The Windows agent pool's specific profile.
     * 
     * @return the windowsProfile value.
     */
    public AgentPoolWindowsProfile windowsProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().windowsProfile();
    }

    /**
     * Set the windowsProfile property: The Windows agent pool's specific profile.
     * 
     * @param windowsProfile the windowsProfile value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withWindowsProfile(AgentPoolWindowsProfile windowsProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withWindowsProfile(windowsProfile);
        return this;
    }

    /**
     * Get the securityProfile property: The security settings of an agent pool.
     * 
     * @return the securityProfile value.
     */
    public AgentPoolSecurityProfile securityProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().securityProfile();
    }

    /**
     * Set the securityProfile property: The security settings of an agent pool.
     * 
     * @param securityProfile the securityProfile value to set.
     * @return the AgentPoolInner object itself.
     */
    public AgentPoolInner withSecurityProfile(AgentPoolSecurityProfile securityProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedClusterAgentPoolProfileProperties();
        }
        this.innerProperties().withSecurityProfile(securityProfile);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentPoolInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentPoolInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AgentPoolInner.
     */
    public static AgentPoolInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentPoolInner deserializedAgentPoolInner = new AgentPoolInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAgentPoolInner.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedAgentPoolInner.innerProperties
                        = ManagedClusterAgentPoolProfileProperties.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedAgentPoolInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAgentPoolInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentPoolInner;
        });
    }
}
