// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Kubernetes version profile for given major.minor release.
 */
@Fluent
public final class KubernetesVersion implements JsonSerializable<KubernetesVersion> {
    /*
     * major.minor version of Kubernetes release
     */
    private String version;

    /*
     * Capabilities on this Kubernetes version.
     */
    private KubernetesVersionCapabilities capabilities;

    /*
     * Whether this version is default.
     */
    private Boolean isDefault;

    /*
     * Whether this version is in preview mode.
     */
    private Boolean isPreview;

    /*
     * Patch versions of Kubernetes release
     */
    private Map<String, KubernetesPatchVersion> patchVersions;

    /**
     * Creates an instance of KubernetesVersion class.
     */
    public KubernetesVersion() {
    }

    /**
     * Get the version property: major.minor version of Kubernetes release.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: major.minor version of Kubernetes release.
     * 
     * @param version the version value to set.
     * @return the KubernetesVersion object itself.
     */
    public KubernetesVersion withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the capabilities property: Capabilities on this Kubernetes version.
     * 
     * @return the capabilities value.
     */
    public KubernetesVersionCapabilities capabilities() {
        return this.capabilities;
    }

    /**
     * Set the capabilities property: Capabilities on this Kubernetes version.
     * 
     * @param capabilities the capabilities value to set.
     * @return the KubernetesVersion object itself.
     */
    public KubernetesVersion withCapabilities(KubernetesVersionCapabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    /**
     * Get the isDefault property: Whether this version is default.
     * 
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Set the isDefault property: Whether this version is default.
     * 
     * @param isDefault the isDefault value to set.
     * @return the KubernetesVersion object itself.
     */
    public KubernetesVersion withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    /**
     * Get the isPreview property: Whether this version is in preview mode.
     * 
     * @return the isPreview value.
     */
    public Boolean isPreview() {
        return this.isPreview;
    }

    /**
     * Set the isPreview property: Whether this version is in preview mode.
     * 
     * @param isPreview the isPreview value to set.
     * @return the KubernetesVersion object itself.
     */
    public KubernetesVersion withIsPreview(Boolean isPreview) {
        this.isPreview = isPreview;
        return this;
    }

    /**
     * Get the patchVersions property: Patch versions of Kubernetes release.
     * 
     * @return the patchVersions value.
     */
    public Map<String, KubernetesPatchVersion> patchVersions() {
        return this.patchVersions;
    }

    /**
     * Set the patchVersions property: Patch versions of Kubernetes release.
     * 
     * @param patchVersions the patchVersions value to set.
     * @return the KubernetesVersion object itself.
     */
    public KubernetesVersion withPatchVersions(Map<String, KubernetesPatchVersion> patchVersions) {
        this.patchVersions = patchVersions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (capabilities() != null) {
            capabilities().validate();
        }
        if (patchVersions() != null) {
            patchVersions().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeJsonField("capabilities", this.capabilities);
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeBooleanField("isPreview", this.isPreview);
        jsonWriter.writeMapField("patchVersions", this.patchVersions, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KubernetesVersion from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KubernetesVersion if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the KubernetesVersion.
     */
    public static KubernetesVersion fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KubernetesVersion deserializedKubernetesVersion = new KubernetesVersion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("version".equals(fieldName)) {
                    deserializedKubernetesVersion.version = reader.getString();
                } else if ("capabilities".equals(fieldName)) {
                    deserializedKubernetesVersion.capabilities = KubernetesVersionCapabilities.fromJson(reader);
                } else if ("isDefault".equals(fieldName)) {
                    deserializedKubernetesVersion.isDefault = reader.getNullable(JsonReader::getBoolean);
                } else if ("isPreview".equals(fieldName)) {
                    deserializedKubernetesVersion.isPreview = reader.getNullable(JsonReader::getBoolean);
                } else if ("patchVersions".equals(fieldName)) {
                    Map<String, KubernetesPatchVersion> patchVersions
                        = reader.readMap(reader1 -> KubernetesPatchVersion.fromJson(reader1));
                    deserializedKubernetesVersion.patchVersions = patchVersions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKubernetesVersion;
        });
    }
}
