// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A run command request.
 */
@Fluent
public final class RunCommandRequest implements JsonSerializable<RunCommandRequest> {
    /*
     * The command to run.
     */
    private String command;

    /*
     * A base64 encoded zip file containing the files required by the command.
     */
    private String context;

    /*
     * AuthToken issued for AKS AAD Server App.
     */
    private String clusterToken;

    /**
     * Creates an instance of RunCommandRequest class.
     */
    public RunCommandRequest() {
    }

    /**
     * Get the command property: The command to run.
     * 
     * @return the command value.
     */
    public String command() {
        return this.command;
    }

    /**
     * Set the command property: The command to run.
     * 
     * @param command the command value to set.
     * @return the RunCommandRequest object itself.
     */
    public RunCommandRequest withCommand(String command) {
        this.command = command;
        return this;
    }

    /**
     * Get the context property: A base64 encoded zip file containing the files required by the command.
     * 
     * @return the context value.
     */
    public String context() {
        return this.context;
    }

    /**
     * Set the context property: A base64 encoded zip file containing the files required by the command.
     * 
     * @param context the context value to set.
     * @return the RunCommandRequest object itself.
     */
    public RunCommandRequest withContext(String context) {
        this.context = context;
        return this;
    }

    /**
     * Get the clusterToken property: AuthToken issued for AKS AAD Server App.
     * 
     * @return the clusterToken value.
     */
    public String clusterToken() {
        return this.clusterToken;
    }

    /**
     * Set the clusterToken property: AuthToken issued for AKS AAD Server App.
     * 
     * @param clusterToken the clusterToken value to set.
     * @return the RunCommandRequest object itself.
     */
    public RunCommandRequest withClusterToken(String clusterToken) {
        this.clusterToken = clusterToken;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (command() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property command in model RunCommandRequest"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RunCommandRequest.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("command", this.command);
        jsonWriter.writeStringField("context", this.context);
        jsonWriter.writeStringField("clusterToken", this.clusterToken);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunCommandRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunCommandRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunCommandRequest.
     */
    public static RunCommandRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunCommandRequest deserializedRunCommandRequest = new RunCommandRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("command".equals(fieldName)) {
                    deserializedRunCommandRequest.command = reader.getString();
                } else if ("context".equals(fieldName)) {
                    deserializedRunCommandRequest.context = reader.getString();
                } else if ("clusterToken".equals(fieldName)) {
                    deserializedRunCommandRequest.clusterToken = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRunCommandRequest;
        });
    }
}
