// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A pod identity exception, which allows pods with certain labels to access the Azure Instance Metadata Service (IMDS)
 * endpoint without being intercepted by the node-managed identity (NMI) server.
 * 
 * See [disable AAD Pod Identity for a specific
 * Pod/Application](https://azure.github.io/aad-pod-identity/docs/configure/application_exception/) for more details.
 */
@Fluent
public final class ManagedClusterPodIdentityException implements JsonSerializable<ManagedClusterPodIdentityException> {
    /*
     * The name of the pod identity exception.
     */
    private String name;

    /*
     * The namespace of the pod identity exception.
     */
    private String namespace;

    /*
     * The pod labels to match.
     */
    private Map<String, String> podLabels;

    /**
     * Creates an instance of ManagedClusterPodIdentityException class.
     */
    public ManagedClusterPodIdentityException() {
    }

    /**
     * Get the name property: The name of the pod identity exception.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the pod identity exception.
     * 
     * @param name the name value to set.
     * @return the ManagedClusterPodIdentityException object itself.
     */
    public ManagedClusterPodIdentityException withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the namespace property: The namespace of the pod identity exception.
     * 
     * @return the namespace value.
     */
    public String namespace() {
        return this.namespace;
    }

    /**
     * Set the namespace property: The namespace of the pod identity exception.
     * 
     * @param namespace the namespace value to set.
     * @return the ManagedClusterPodIdentityException object itself.
     */
    public ManagedClusterPodIdentityException withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    /**
     * Get the podLabels property: The pod labels to match.
     * 
     * @return the podLabels value.
     */
    public Map<String, String> podLabels() {
        return this.podLabels;
    }

    /**
     * Set the podLabels property: The pod labels to match.
     * 
     * @param podLabels the podLabels value to set.
     * @return the ManagedClusterPodIdentityException object itself.
     */
    public ManagedClusterPodIdentityException withPodLabels(Map<String, String> podLabels) {
        this.podLabels = podLabels;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property name in model ManagedClusterPodIdentityException"));
        }
        if (namespace() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property namespace in model ManagedClusterPodIdentityException"));
        }
        if (podLabels() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property podLabels in model ManagedClusterPodIdentityException"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterPodIdentityException.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeMapField("podLabels", this.podLabels, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterPodIdentityException from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterPodIdentityException if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedClusterPodIdentityException.
     */
    public static ManagedClusterPodIdentityException fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterPodIdentityException deserializedManagedClusterPodIdentityException
                = new ManagedClusterPodIdentityException();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedManagedClusterPodIdentityException.name = reader.getString();
                } else if ("namespace".equals(fieldName)) {
                    deserializedManagedClusterPodIdentityException.namespace = reader.getString();
                } else if ("podLabels".equals(fieldName)) {
                    Map<String, String> podLabels = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedClusterPodIdentityException.podLabels = podLabels;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterPodIdentityException;
        });
    }
}
