// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Settings for overrides when upgrading a cluster.
 */
@Fluent
public final class UpgradeOverrideSettings implements JsonSerializable<UpgradeOverrideSettings> {
    /*
     * Whether to force upgrade the cluster. Note that this option instructs upgrade operation to bypass upgrade
     * protections such as checking for deprecated API usage. Enable this option only with caution.
     */
    private Boolean forceUpgrade;

    /*
     * Until when the overrides are effective. Note that this only matches the start time of an upgrade, and the
     * effectiveness won't change once an upgrade starts even if the `until` expires as upgrade proceeds. This field is
     * not set by default. It must be set for the overrides to take effect.
     */
    private OffsetDateTime until;

    /**
     * Creates an instance of UpgradeOverrideSettings class.
     */
    public UpgradeOverrideSettings() {
    }

    /**
     * Get the forceUpgrade property: Whether to force upgrade the cluster. Note that this option instructs upgrade
     * operation to bypass upgrade protections such as checking for deprecated API usage. Enable this option only with
     * caution.
     * 
     * @return the forceUpgrade value.
     */
    public Boolean forceUpgrade() {
        return this.forceUpgrade;
    }

    /**
     * Set the forceUpgrade property: Whether to force upgrade the cluster. Note that this option instructs upgrade
     * operation to bypass upgrade protections such as checking for deprecated API usage. Enable this option only with
     * caution.
     * 
     * @param forceUpgrade the forceUpgrade value to set.
     * @return the UpgradeOverrideSettings object itself.
     */
    public UpgradeOverrideSettings withForceUpgrade(Boolean forceUpgrade) {
        this.forceUpgrade = forceUpgrade;
        return this;
    }

    /**
     * Get the until property: Until when the overrides are effective. Note that this only matches the start time of an
     * upgrade, and the effectiveness won't change once an upgrade starts even if the `until` expires as upgrade
     * proceeds. This field is not set by default. It must be set for the overrides to take effect.
     * 
     * @return the until value.
     */
    public OffsetDateTime until() {
        return this.until;
    }

    /**
     * Set the until property: Until when the overrides are effective. Note that this only matches the start time of an
     * upgrade, and the effectiveness won't change once an upgrade starts even if the `until` expires as upgrade
     * proceeds. This field is not set by default. It must be set for the overrides to take effect.
     * 
     * @param until the until value to set.
     * @return the UpgradeOverrideSettings object itself.
     */
    public UpgradeOverrideSettings withUntil(OffsetDateTime until) {
        this.until = until;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("forceUpgrade", this.forceUpgrade);
        jsonWriter.writeStringField("until",
            this.until == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.until));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UpgradeOverrideSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UpgradeOverrideSettings if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UpgradeOverrideSettings.
     */
    public static UpgradeOverrideSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UpgradeOverrideSettings deserializedUpgradeOverrideSettings = new UpgradeOverrideSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("forceUpgrade".equals(fieldName)) {
                    deserializedUpgradeOverrideSettings.forceUpgrade = reader.getNullable(JsonReader::getBoolean);
                } else if ("until".equals(fieldName)) {
                    deserializedUpgradeOverrideSettings.until = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUpgradeOverrideSettings;
        });
    }
}
