// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * AzureDisk CSI Driver settings for the storage profile.
 */
@Fluent
public final class ManagedClusterStorageProfileDiskCsiDriver
    implements JsonSerializable<ManagedClusterStorageProfileDiskCsiDriver> {
    /*
     * Whether to enable AzureDisk CSI Driver. The default value is true.
     */
    private Boolean enabled;

    /**
     * Creates an instance of ManagedClusterStorageProfileDiskCsiDriver class.
     */
    public ManagedClusterStorageProfileDiskCsiDriver() {
    }

    /**
     * Get the enabled property: Whether to enable AzureDisk CSI Driver. The default value is true.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether to enable AzureDisk CSI Driver. The default value is true.
     * 
     * @param enabled the enabled value to set.
     * @return the ManagedClusterStorageProfileDiskCsiDriver object itself.
     */
    public ManagedClusterStorageProfileDiskCsiDriver withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterStorageProfileDiskCsiDriver from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterStorageProfileDiskCsiDriver if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterStorageProfileDiskCsiDriver.
     */
    public static ManagedClusterStorageProfileDiskCsiDriver fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterStorageProfileDiskCsiDriver deserializedManagedClusterStorageProfileDiskCsiDriver
                = new ManagedClusterStorageProfileDiskCsiDriver();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedManagedClusterStorageProfileDiskCsiDriver.enabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterStorageProfileDiskCsiDriver;
        });
    }
}
