/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.MachineProperties;
import java.io.IOException;

public final class MachineInner
extends SubResource {
    private MachineProperties properties;
    private String name;
    private String type;

    public MachineProperties properties() {
        return this.properties;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public MachineInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        return jsonWriter.writeEndObject();
    }

    public static MachineInner fromJson(JsonReader jsonReader) throws IOException {
        return (MachineInner)((Object)jsonReader.readObject(reader -> {
            MachineInner deserializedMachineInner = new MachineInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMachineInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedMachineInner.properties = MachineProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMachineInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMachineInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMachineInner;
        }));
    }
}

