/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.MachineInner;
import java.io.IOException;
import java.util.List;

public final class MachineListResult
implements JsonSerializable<MachineListResult> {
    private String nextLink;
    private List<MachineInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public List<MachineInner> value() {
        return this.value;
    }

    public MachineListResult withValue(List<MachineInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MachineListResult fromJson(JsonReader jsonReader) throws IOException {
        return (MachineListResult)jsonReader.readObject(reader -> {
            MachineListResult deserializedMachineListResult = new MachineListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedMachineListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedMachineListResult.value = value = reader.readArray(reader1 -> MachineInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMachineListResult;
        });
    }
}

