/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterIdentityProvider;
import java.io.IOException;
import java.util.List;

public final class OpenShiftManagedClusterAuthProfile
implements JsonSerializable<OpenShiftManagedClusterAuthProfile> {
    private List<OpenShiftManagedClusterIdentityProvider> identityProviders;

    public List<OpenShiftManagedClusterIdentityProvider> identityProviders() {
        return this.identityProviders;
    }

    public OpenShiftManagedClusterAuthProfile withIdentityProviders(List<OpenShiftManagedClusterIdentityProvider> identityProviders) {
        this.identityProviders = identityProviders;
        return this;
    }

    public void validate() {
        if (this.identityProviders() != null) {
            this.identityProviders().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("identityProviders", this.identityProviders, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OpenShiftManagedClusterAuthProfile fromJson(JsonReader jsonReader) throws IOException {
        return (OpenShiftManagedClusterAuthProfile)jsonReader.readObject(reader -> {
            OpenShiftManagedClusterAuthProfile deserializedOpenShiftManagedClusterAuthProfile = new OpenShiftManagedClusterAuthProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identityProviders".equals(fieldName)) {
                    List identityProviders;
                    deserializedOpenShiftManagedClusterAuthProfile.identityProviders = identityProviders = reader.readArray(reader1 -> OpenShiftManagedClusterIdentityProvider.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenShiftManagedClusterAuthProfile;
        });
    }
}

