// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.containerservice.fluent.models.TrustedAccessRoleBindingInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in TrustedAccessRoleBindingsClient.
 */
public interface TrustedAccessRoleBindingsClient {
    /**
     * List trusted access role bindings.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of trusted access role bindings as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<TrustedAccessRoleBindingInner> listAsync(String resourceGroupName, String resourceName);

    /**
     * List trusted access role bindings.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of trusted access role bindings as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<TrustedAccessRoleBindingInner> list(String resourceGroupName, String resourceName);

    /**
     * List trusted access role bindings.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of trusted access role bindings as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<TrustedAccessRoleBindingInner> list(String resourceGroupName, String resourceName, Context context);

    /**
     * Get a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a trusted access role binding along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<TrustedAccessRoleBindingInner>> getWithResponseAsync(String resourceGroupName, String resourceName,
        String trustedAccessRoleBindingName);

    /**
     * Get a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a trusted access role binding on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TrustedAccessRoleBindingInner> getAsync(String resourceGroupName, String resourceName,
        String trustedAccessRoleBindingName);

    /**
     * Get a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a trusted access role binding along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<TrustedAccessRoleBindingInner> getWithResponse(String resourceGroupName, String resourceName,
        String trustedAccessRoleBindingName, Context context);

    /**
     * Get a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a trusted access role binding.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TrustedAccessRoleBindingInner get(String resourceGroupName, String resourceName,
        String trustedAccessRoleBindingName);

    /**
     * Create or update a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @param trustedAccessRoleBinding A trusted access role binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines binding between a resource and role along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName,
        String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding);

    /**
     * Create or update a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @param trustedAccessRoleBinding A trusted access role binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of defines binding between a resource and role.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<TrustedAccessRoleBindingInner>, TrustedAccessRoleBindingInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String resourceName, String trustedAccessRoleBindingName,
        TrustedAccessRoleBindingInner trustedAccessRoleBinding);

    /**
     * Create or update a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @param trustedAccessRoleBinding A trusted access role binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of defines binding between a resource and role.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<TrustedAccessRoleBindingInner>, TrustedAccessRoleBindingInner> beginCreateOrUpdate(
        String resourceGroupName, String resourceName, String trustedAccessRoleBindingName,
        TrustedAccessRoleBindingInner trustedAccessRoleBinding);

    /**
     * Create or update a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @param trustedAccessRoleBinding A trusted access role binding.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of defines binding between a resource and role.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<TrustedAccessRoleBindingInner>, TrustedAccessRoleBindingInner> beginCreateOrUpdate(
        String resourceGroupName, String resourceName, String trustedAccessRoleBindingName,
        TrustedAccessRoleBindingInner trustedAccessRoleBinding, Context context);

    /**
     * Create or update a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @param trustedAccessRoleBinding A trusted access role binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines binding between a resource and role on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TrustedAccessRoleBindingInner> createOrUpdateAsync(String resourceGroupName, String resourceName,
        String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding);

    /**
     * Create or update a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @param trustedAccessRoleBinding A trusted access role binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines binding between a resource and role.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TrustedAccessRoleBindingInner createOrUpdate(String resourceGroupName, String resourceName,
        String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding);

    /**
     * Create or update a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @param trustedAccessRoleBinding A trusted access role binding.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return defines binding between a resource and role.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TrustedAccessRoleBindingInner createOrUpdate(String resourceGroupName, String resourceName,
        String trustedAccessRoleBindingName, TrustedAccessRoleBindingInner trustedAccessRoleBinding, Context context);

    /**
     * Delete a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceName,
        String trustedAccessRoleBindingName);

    /**
     * Delete a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String resourceName,
        String trustedAccessRoleBindingName);

    /**
     * Delete a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceName,
        String trustedAccessRoleBindingName);

    /**
     * Delete a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceName,
        String trustedAccessRoleBindingName, Context context);

    /**
     * Delete a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName);

    /**
     * Delete a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName);

    /**
     * Delete a trusted access role binding.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the managed cluster resource.
     * @param trustedAccessRoleBindingName The name of trusted access role binding.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String resourceName, String trustedAccessRoleBindingName, Context context);
}
