// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the properties of a Operation Value Display.
 */
@Immutable
public final class OperationValueDisplay implements JsonSerializable<OperationValueDisplay> {
    /*
     * The display name of the operation.
     */
    private String operation;

    /*
     * The display name of the resource the operation applies to.
     */
    private String resource;

    /*
     * The description of the operation.
     */
    private String description;

    /*
     * The resource provider for the operation.
     */
    private String provider;

    /**
     * Creates an instance of OperationValueDisplay class.
     */
    public OperationValueDisplay() {
    }

    /**
     * Get the operation property: The display name of the operation.
     * 
     * @return the operation value.
     */
    public String operation() {
        return this.operation;
    }

    /**
     * Get the resource property: The display name of the resource the operation applies to.
     * 
     * @return the resource value.
     */
    public String resource() {
        return this.resource;
    }

    /**
     * Get the description property: The description of the operation.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the provider property: The resource provider for the operation.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.provider;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OperationValueDisplay from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OperationValueDisplay if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OperationValueDisplay.
     */
    public static OperationValueDisplay fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OperationValueDisplay deserializedOperationValueDisplay = new OperationValueDisplay();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operation".equals(fieldName)) {
                    deserializedOperationValueDisplay.operation = reader.getString();
                } else if ("resource".equals(fieldName)) {
                    deserializedOperationValueDisplay.resource = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedOperationValueDisplay.description = reader.getString();
                } else if ("provider".equals(fieldName)) {
                    deserializedOperationValueDisplay.provider = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOperationValueDisplay;
        });
    }
}
