// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

/**
 * Delegated resource properties - internal use only.
 */
@Fluent
public final class DelegatedResource implements JsonSerializable<DelegatedResource> {
    /*
     * The ARM resource id of the delegated resource - internal use only.
     */
    private String resourceId;

    /*
     * The tenant id of the delegated resource - internal use only.
     */
    private UUID tenantId;

    /*
     * The delegation id of the referral delegation (optional) - internal use only.
     */
    private String referralResource;

    /*
     * The source resource location - internal use only.
     */
    private String location;

    /**
     * Creates an instance of DelegatedResource class.
     */
    public DelegatedResource() {
    }

    /**
     * Get the resourceId property: The ARM resource id of the delegated resource - internal use only.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The ARM resource id of the delegated resource - internal use only.
     * 
     * @param resourceId the resourceId value to set.
     * @return the DelegatedResource object itself.
     */
    public DelegatedResource withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the tenantId property: The tenant id of the delegated resource - internal use only.
     * 
     * @return the tenantId value.
     */
    public UUID tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: The tenant id of the delegated resource - internal use only.
     * 
     * @param tenantId the tenantId value to set.
     * @return the DelegatedResource object itself.
     */
    public DelegatedResource withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the referralResource property: The delegation id of the referral delegation (optional) - internal use only.
     * 
     * @return the referralResource value.
     */
    public String referralResource() {
        return this.referralResource;
    }

    /**
     * Set the referralResource property: The delegation id of the referral delegation (optional) - internal use only.
     * 
     * @param referralResource the referralResource value to set.
     * @return the DelegatedResource object itself.
     */
    public DelegatedResource withReferralResource(String referralResource) {
        this.referralResource = referralResource;
        return this;
    }

    /**
     * Get the location property: The source resource location - internal use only.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The source resource location - internal use only.
     * 
     * @param location the location value to set.
     * @return the DelegatedResource object itself.
     */
    public DelegatedResource withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("tenantId", Objects.toString(this.tenantId, null));
        jsonWriter.writeStringField("referralResource", this.referralResource);
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DelegatedResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DelegatedResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DelegatedResource.
     */
    public static DelegatedResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DelegatedResource deserializedDelegatedResource = new DelegatedResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceId".equals(fieldName)) {
                    deserializedDelegatedResource.resourceId = reader.getString();
                } else if ("tenantId".equals(fieldName)) {
                    deserializedDelegatedResource.tenantId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("referralResource".equals(fieldName)) {
                    deserializedDelegatedResource.referralResource = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedDelegatedResource.location = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDelegatedResource;
        });
    }
}
