// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The machine IP address details.
 */
@Immutable
public final class MachineIpAddress implements JsonSerializable<MachineIpAddress> {
    /*
     * To determine if address belongs IPv4 or IPv6 family
     */
    private IpFamily family;

    /*
     * IPv4 or IPv6 address of the machine
     */
    private String ip;

    /**
     * Creates an instance of MachineIpAddress class.
     */
    public MachineIpAddress() {
    }

    /**
     * Get the family property: To determine if address belongs IPv4 or IPv6 family.
     * 
     * @return the family value.
     */
    public IpFamily family() {
        return this.family;
    }

    /**
     * Get the ip property: IPv4 or IPv6 address of the machine.
     * 
     * @return the ip value.
     */
    public String ip() {
        return this.ip;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MachineIpAddress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MachineIpAddress if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MachineIpAddress.
     */
    public static MachineIpAddress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MachineIpAddress deserializedMachineIpAddress = new MachineIpAddress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("family".equals(fieldName)) {
                    deserializedMachineIpAddress.family = IpFamily.fromString(reader.getString());
                } else if ("ip".equals(fieldName)) {
                    deserializedMachineIpAddress.ip = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMachineIpAddress;
        });
    }
}
