// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Application Routing add-on settings for the ingress profile.
 */
@Fluent
public final class ManagedClusterIngressProfileWebAppRouting
    implements JsonSerializable<ManagedClusterIngressProfileWebAppRouting> {
    /*
     * Whether to enable the Application Routing add-on.
     */
    private Boolean enabled;

    /*
     * Resource IDs of the DNS zones to be associated with the Application Routing add-on. Used only when Application
     * Routing add-on is enabled. Public and private DNS zones can be in different resource groups, but all public DNS
     * zones must be in the same resource group and all private DNS zones must be in the same resource group.
     */
    private List<String> dnsZoneResourceIds;

    /*
     * Managed identity of the Application Routing add-on. This is the identity that should be granted permissions, for
     * example, to manage the associated Azure DNS resource and get certificates from Azure Key Vault. See [this
     * overview of the add-on](https://learn.microsoft.com/en-us/azure/aks/web-app-routing?tabs=with-osm) for more
     * instructions.
     */
    private UserAssignedIdentity identity;

    /**
     * Creates an instance of ManagedClusterIngressProfileWebAppRouting class.
     */
    public ManagedClusterIngressProfileWebAppRouting() {
    }

    /**
     * Get the enabled property: Whether to enable the Application Routing add-on.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Whether to enable the Application Routing add-on.
     * 
     * @param enabled the enabled value to set.
     * @return the ManagedClusterIngressProfileWebAppRouting object itself.
     */
    public ManagedClusterIngressProfileWebAppRouting withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the dnsZoneResourceIds property: Resource IDs of the DNS zones to be associated with the Application Routing
     * add-on. Used only when Application Routing add-on is enabled. Public and private DNS zones can be in different
     * resource groups, but all public DNS zones must be in the same resource group and all private DNS zones must be in
     * the same resource group.
     * 
     * @return the dnsZoneResourceIds value.
     */
    public List<String> dnsZoneResourceIds() {
        return this.dnsZoneResourceIds;
    }

    /**
     * Set the dnsZoneResourceIds property: Resource IDs of the DNS zones to be associated with the Application Routing
     * add-on. Used only when Application Routing add-on is enabled. Public and private DNS zones can be in different
     * resource groups, but all public DNS zones must be in the same resource group and all private DNS zones must be in
     * the same resource group.
     * 
     * @param dnsZoneResourceIds the dnsZoneResourceIds value to set.
     * @return the ManagedClusterIngressProfileWebAppRouting object itself.
     */
    public ManagedClusterIngressProfileWebAppRouting withDnsZoneResourceIds(List<String> dnsZoneResourceIds) {
        this.dnsZoneResourceIds = dnsZoneResourceIds;
        return this;
    }

    /**
     * Get the identity property: Managed identity of the Application Routing add-on. This is the identity that should
     * be granted permissions, for example, to manage the associated Azure DNS resource and get certificates from Azure
     * Key Vault. See [this overview of the
     * add-on](https://learn.microsoft.com/en-us/azure/aks/web-app-routing?tabs=with-osm) for more instructions.
     * 
     * @return the identity value.
     */
    public UserAssignedIdentity identity() {
        return this.identity;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("dnsZoneResourceIds", this.dnsZoneResourceIds,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterIngressProfileWebAppRouting from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterIngressProfileWebAppRouting if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterIngressProfileWebAppRouting.
     */
    public static ManagedClusterIngressProfileWebAppRouting fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterIngressProfileWebAppRouting deserializedManagedClusterIngressProfileWebAppRouting
                = new ManagedClusterIngressProfileWebAppRouting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedManagedClusterIngressProfileWebAppRouting.enabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("dnsZoneResourceIds".equals(fieldName)) {
                    List<String> dnsZoneResourceIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedManagedClusterIngressProfileWebAppRouting.dnsZoneResourceIds = dnsZoneResourceIds;
                } else if ("identity".equals(fieldName)) {
                    deserializedManagedClusterIngressProfileWebAppRouting.identity
                        = UserAssignedIdentity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterIngressProfileWebAppRouting;
        });
    }
}
