// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Node resource group lockdown profile for a managed cluster.
 */
@Fluent
public final class ManagedClusterNodeResourceGroupProfile
    implements JsonSerializable<ManagedClusterNodeResourceGroupProfile> {
    /*
     * The restriction level applied to the cluster's node resource group. If not specified, the default is
     * 'Unrestricted'
     */
    private RestrictionLevel restrictionLevel;

    /**
     * Creates an instance of ManagedClusterNodeResourceGroupProfile class.
     */
    public ManagedClusterNodeResourceGroupProfile() {
    }

    /**
     * Get the restrictionLevel property: The restriction level applied to the cluster's node resource group. If not
     * specified, the default is 'Unrestricted'.
     * 
     * @return the restrictionLevel value.
     */
    public RestrictionLevel restrictionLevel() {
        return this.restrictionLevel;
    }

    /**
     * Set the restrictionLevel property: The restriction level applied to the cluster's node resource group. If not
     * specified, the default is 'Unrestricted'.
     * 
     * @param restrictionLevel the restrictionLevel value to set.
     * @return the ManagedClusterNodeResourceGroupProfile object itself.
     */
    public ManagedClusterNodeResourceGroupProfile withRestrictionLevel(RestrictionLevel restrictionLevel) {
        this.restrictionLevel = restrictionLevel;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("restrictionLevel",
            this.restrictionLevel == null ? null : this.restrictionLevel.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterNodeResourceGroupProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterNodeResourceGroupProfile if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterNodeResourceGroupProfile.
     */
    public static ManagedClusterNodeResourceGroupProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterNodeResourceGroupProfile deserializedManagedClusterNodeResourceGroupProfile
                = new ManagedClusterNodeResourceGroupProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("restrictionLevel".equals(fieldName)) {
                    deserializedManagedClusterNodeResourceGroupProfile.restrictionLevel
                        = RestrictionLevel.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterNodeResourceGroupProfile;
        });
    }
}
