// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.TimeInWeek;
import com.azure.resourcemanager.containerservice.models.TimeSpan;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** maintenance configuration. */
@JsonFlatten
@Fluent
public class MaintenanceConfigurationInner extends SubResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MaintenanceConfigurationInner.class);

    /*
     * The system meta data relating to this resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /*
     * Weekday time slots allowed to upgrade.
     */
    @JsonProperty(value = "properties.timeInWeek")
    private List<TimeInWeek> timeInWeek;

    /*
     * Time slots on which upgrade is not allowed.
     */
    @JsonProperty(value = "properties.notAllowedTime")
    private List<TimeSpan> notAllowedTime;

    /*
     * The name of the resource that is unique within a resource group. This
     * name can be used to access the resource.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * Resource type
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * Get the systemData property: The system meta data relating to this resource.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the timeInWeek property: Weekday time slots allowed to upgrade.
     *
     * @return the timeInWeek value.
     */
    public List<TimeInWeek> timeInWeek() {
        return this.timeInWeek;
    }

    /**
     * Set the timeInWeek property: Weekday time slots allowed to upgrade.
     *
     * @param timeInWeek the timeInWeek value to set.
     * @return the MaintenanceConfigurationInner object itself.
     */
    public MaintenanceConfigurationInner withTimeInWeek(List<TimeInWeek> timeInWeek) {
        this.timeInWeek = timeInWeek;
        return this;
    }

    /**
     * Get the notAllowedTime property: Time slots on which upgrade is not allowed.
     *
     * @return the notAllowedTime value.
     */
    public List<TimeSpan> notAllowedTime() {
        return this.notAllowedTime;
    }

    /**
     * Set the notAllowedTime property: Time slots on which upgrade is not allowed.
     *
     * @param notAllowedTime the notAllowedTime value to set.
     * @return the MaintenanceConfigurationInner object itself.
     */
    public MaintenanceConfigurationInner withNotAllowedTime(List<TimeSpan> notAllowedTime) {
        this.notAllowedTime = notAllowedTime;
        return this;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Resource type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /** {@inheritDoc} */
    @Override
    public MaintenanceConfigurationInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (timeInWeek() != null) {
            timeInWeek().forEach(e -> e.validate());
        }
        if (notAllowedTime() != null) {
            notAllowedTime().forEach(e -> e.validate());
        }
    }
}
