// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** run command result. */
@JsonFlatten
@Immutable
public class RunCommandResultInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RunCommandResultInner.class);

    /*
     * command id.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * provisioning State
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /*
     * exit code of the command
     */
    @JsonProperty(value = "properties.exitCode", access = JsonProperty.Access.WRITE_ONLY)
    private Integer exitCode;

    /*
     * time when the command started.
     */
    @JsonProperty(value = "properties.startedAt", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime startedAt;

    /*
     * time when the command finished.
     */
    @JsonProperty(value = "properties.finishedAt", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime finishedAt;

    /*
     * command output.
     */
    @JsonProperty(value = "properties.logs", access = JsonProperty.Access.WRITE_ONLY)
    private String logs;

    /*
     * explain why provisioningState is set to failed (if so).
     */
    @JsonProperty(value = "properties.reason", access = JsonProperty.Access.WRITE_ONLY)
    private String reason;

    /**
     * Get the id property: command id.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: provisioning State.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the exitCode property: exit code of the command.
     *
     * @return the exitCode value.
     */
    public Integer exitCode() {
        return this.exitCode;
    }

    /**
     * Get the startedAt property: time when the command started.
     *
     * @return the startedAt value.
     */
    public OffsetDateTime startedAt() {
        return this.startedAt;
    }

    /**
     * Get the finishedAt property: time when the command finished.
     *
     * @return the finishedAt value.
     */
    public OffsetDateTime finishedAt() {
        return this.finishedAt;
    }

    /**
     * Get the logs property: command output.
     *
     * @return the logs value.
     */
    public String logs() {
        return this.logs;
    }

    /**
     * Get the reason property: explain why provisioningState is set to failed (if so).
     *
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
