// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Settings for upgrading an agentpool. */
@Fluent
public final class AgentPoolUpgradeSettings {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(AgentPoolUpgradeSettings.class);

    /*
     * Count or percentage of additional nodes to be added during upgrade. If
     * empty uses AKS default
     */
    @JsonProperty(value = "maxSurge")
    private String maxSurge;

    /**
     * Get the maxSurge property: Count or percentage of additional nodes to be added during upgrade. If empty uses AKS
     * default.
     *
     * @return the maxSurge value.
     */
    public String maxSurge() {
        return this.maxSurge;
    }

    /**
     * Set the maxSurge property: Count or percentage of additional nodes to be added during upgrade. If empty uses AKS
     * default.
     *
     * @param maxSurge the maxSurge value to set.
     * @return the AgentPoolUpgradeSettings object itself.
     */
    public AgentPoolUpgradeSettings withMaxSurge(String maxSurge) {
        this.maxSurge = maxSurge;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
