// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Profile of network configuration. */
@Fluent
public final class ContainerServiceNetworkProfile {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ContainerServiceNetworkProfile.class);

    /*
     * Network plugin used for building Kubernetes network.
     */
    @JsonProperty(value = "networkPlugin")
    private NetworkPlugin networkPlugin;

    /*
     * Network policy used for building Kubernetes network.
     */
    @JsonProperty(value = "networkPolicy")
    private NetworkPolicy networkPolicy;

    /*
     * Network mode used for building Kubernetes network.
     */
    @JsonProperty(value = "networkMode")
    private NetworkMode networkMode;

    /*
     * A CIDR notation IP range from which to assign pod IPs when kubenet is
     * used.
     */
    @JsonProperty(value = "podCidr")
    private String podCidr;

    /*
     * A CIDR notation IP range from which to assign service cluster IPs. It
     * must not overlap with any Subnet IP ranges.
     */
    @JsonProperty(value = "serviceCidr")
    private String serviceCidr;

    /*
     * An IP address assigned to the Kubernetes DNS service. It must be within
     * the Kubernetes service address range specified in serviceCidr.
     */
    @JsonProperty(value = "dnsServiceIP")
    private String dnsServiceIp;

    /*
     * A CIDR notation IP range assigned to the Docker bridge network. It must
     * not overlap with any Subnet IP ranges or the Kubernetes service address
     * range.
     */
    @JsonProperty(value = "dockerBridgeCidr")
    private String dockerBridgeCidr;

    /*
     * The outbound (egress) routing method.
     */
    @JsonProperty(value = "outboundType")
    private OutboundType outboundType;

    /*
     * The load balancer sku for the managed cluster.
     */
    @JsonProperty(value = "loadBalancerSku")
    private LoadBalancerSku loadBalancerSku;

    /*
     * Profile of the cluster load balancer.
     */
    @JsonProperty(value = "loadBalancerProfile")
    private ManagedClusterLoadBalancerProfile loadBalancerProfile;

    /**
     * Get the networkPlugin property: Network plugin used for building Kubernetes network.
     *
     * @return the networkPlugin value.
     */
    public NetworkPlugin networkPlugin() {
        return this.networkPlugin;
    }

    /**
     * Set the networkPlugin property: Network plugin used for building Kubernetes network.
     *
     * @param networkPlugin the networkPlugin value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withNetworkPlugin(NetworkPlugin networkPlugin) {
        this.networkPlugin = networkPlugin;
        return this;
    }

    /**
     * Get the networkPolicy property: Network policy used for building Kubernetes network.
     *
     * @return the networkPolicy value.
     */
    public NetworkPolicy networkPolicy() {
        return this.networkPolicy;
    }

    /**
     * Set the networkPolicy property: Network policy used for building Kubernetes network.
     *
     * @param networkPolicy the networkPolicy value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withNetworkPolicy(NetworkPolicy networkPolicy) {
        this.networkPolicy = networkPolicy;
        return this;
    }

    /**
     * Get the networkMode property: Network mode used for building Kubernetes network.
     *
     * @return the networkMode value.
     */
    public NetworkMode networkMode() {
        return this.networkMode;
    }

    /**
     * Set the networkMode property: Network mode used for building Kubernetes network.
     *
     * @param networkMode the networkMode value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withNetworkMode(NetworkMode networkMode) {
        this.networkMode = networkMode;
        return this;
    }

    /**
     * Get the podCidr property: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
     *
     * @return the podCidr value.
     */
    public String podCidr() {
        return this.podCidr;
    }

    /**
     * Set the podCidr property: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
     *
     * @param podCidr the podCidr value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withPodCidr(String podCidr) {
        this.podCidr = podCidr;
        return this;
    }

    /**
     * Get the serviceCidr property: A CIDR notation IP range from which to assign service cluster IPs. It must not
     * overlap with any Subnet IP ranges.
     *
     * @return the serviceCidr value.
     */
    public String serviceCidr() {
        return this.serviceCidr;
    }

    /**
     * Set the serviceCidr property: A CIDR notation IP range from which to assign service cluster IPs. It must not
     * overlap with any Subnet IP ranges.
     *
     * @param serviceCidr the serviceCidr value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withServiceCidr(String serviceCidr) {
        this.serviceCidr = serviceCidr;
        return this;
    }

    /**
     * Get the dnsServiceIp property: An IP address assigned to the Kubernetes DNS service. It must be within the
     * Kubernetes service address range specified in serviceCidr.
     *
     * @return the dnsServiceIp value.
     */
    public String dnsServiceIp() {
        return this.dnsServiceIp;
    }

    /**
     * Set the dnsServiceIp property: An IP address assigned to the Kubernetes DNS service. It must be within the
     * Kubernetes service address range specified in serviceCidr.
     *
     * @param dnsServiceIp the dnsServiceIp value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withDnsServiceIp(String dnsServiceIp) {
        this.dnsServiceIp = dnsServiceIp;
        return this;
    }

    /**
     * Get the dockerBridgeCidr property: A CIDR notation IP range assigned to the Docker bridge network. It must not
     * overlap with any Subnet IP ranges or the Kubernetes service address range.
     *
     * @return the dockerBridgeCidr value.
     */
    public String dockerBridgeCidr() {
        return this.dockerBridgeCidr;
    }

    /**
     * Set the dockerBridgeCidr property: A CIDR notation IP range assigned to the Docker bridge network. It must not
     * overlap with any Subnet IP ranges or the Kubernetes service address range.
     *
     * @param dockerBridgeCidr the dockerBridgeCidr value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withDockerBridgeCidr(String dockerBridgeCidr) {
        this.dockerBridgeCidr = dockerBridgeCidr;
        return this;
    }

    /**
     * Get the outboundType property: The outbound (egress) routing method.
     *
     * @return the outboundType value.
     */
    public OutboundType outboundType() {
        return this.outboundType;
    }

    /**
     * Set the outboundType property: The outbound (egress) routing method.
     *
     * @param outboundType the outboundType value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withOutboundType(OutboundType outboundType) {
        this.outboundType = outboundType;
        return this;
    }

    /**
     * Get the loadBalancerSku property: The load balancer sku for the managed cluster.
     *
     * @return the loadBalancerSku value.
     */
    public LoadBalancerSku loadBalancerSku() {
        return this.loadBalancerSku;
    }

    /**
     * Set the loadBalancerSku property: The load balancer sku for the managed cluster.
     *
     * @param loadBalancerSku the loadBalancerSku value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withLoadBalancerSku(LoadBalancerSku loadBalancerSku) {
        this.loadBalancerSku = loadBalancerSku;
        return this;
    }

    /**
     * Get the loadBalancerProfile property: Profile of the cluster load balancer.
     *
     * @return the loadBalancerProfile value.
     */
    public ManagedClusterLoadBalancerProfile loadBalancerProfile() {
        return this.loadBalancerProfile;
    }

    /**
     * Set the loadBalancerProfile property: Profile of the cluster load balancer.
     *
     * @param loadBalancerProfile the loadBalancerProfile value to set.
     * @return the ContainerServiceNetworkProfile object itself.
     */
    public ContainerServiceNetworkProfile withLoadBalancerProfile(
        ManagedClusterLoadBalancerProfile loadBalancerProfile) {
        this.loadBalancerProfile = loadBalancerProfile;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (loadBalancerProfile() != null) {
            loadBalancerProfile().validate();
        }
    }
}
