// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for Count. */
public enum Count {
    /** Enum value 1. */
    ONE(1),

    /** Enum value 3. */
    THREE(3),

    /** Enum value 5. */
    FIVE(5);

    /** The actual serialized value for a Count instance. */
    private final int value;

    Count(int value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a Count instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed Count object, or null if unable to parse.
     */
    @JsonCreator
    public static Count fromInt(int value) {
        Count[] items = Count.values();
        for (Count item : items) {
            if (item.toInt() == value) {
                return item;
            }
        }
        return null;
    }

    /**
     * De-serializes the instance to int value.
     *
     * @return the int value.
     */
    @JsonValue
    public int toInt() {
        return this.value;
    }
}
