// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** OS configurations of Linux agent nodes. */
@Fluent
public final class LinuxOSConfig {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(LinuxOSConfig.class);

    /*
     * Sysctl settings for Linux agent nodes.
     */
    @JsonProperty(value = "sysctls")
    private SysctlConfig sysctls;

    /*
     * Transparent Huge Page enabled configuration.
     */
    @JsonProperty(value = "transparentHugePageEnabled")
    private String transparentHugePageEnabled;

    /*
     * Transparent Huge Page defrag configuration.
     */
    @JsonProperty(value = "transparentHugePageDefrag")
    private String transparentHugePageDefrag;

    /*
     * SwapFileSizeMB specifies size in MB of a swap file will be created on
     * each node.
     */
    @JsonProperty(value = "swapFileSizeMB")
    private Integer swapFileSizeMB;

    /**
     * Get the sysctls property: Sysctl settings for Linux agent nodes.
     *
     * @return the sysctls value.
     */
    public SysctlConfig sysctls() {
        return this.sysctls;
    }

    /**
     * Set the sysctls property: Sysctl settings for Linux agent nodes.
     *
     * @param sysctls the sysctls value to set.
     * @return the LinuxOSConfig object itself.
     */
    public LinuxOSConfig withSysctls(SysctlConfig sysctls) {
        this.sysctls = sysctls;
        return this;
    }

    /**
     * Get the transparentHugePageEnabled property: Transparent Huge Page enabled configuration.
     *
     * @return the transparentHugePageEnabled value.
     */
    public String transparentHugePageEnabled() {
        return this.transparentHugePageEnabled;
    }

    /**
     * Set the transparentHugePageEnabled property: Transparent Huge Page enabled configuration.
     *
     * @param transparentHugePageEnabled the transparentHugePageEnabled value to set.
     * @return the LinuxOSConfig object itself.
     */
    public LinuxOSConfig withTransparentHugePageEnabled(String transparentHugePageEnabled) {
        this.transparentHugePageEnabled = transparentHugePageEnabled;
        return this;
    }

    /**
     * Get the transparentHugePageDefrag property: Transparent Huge Page defrag configuration.
     *
     * @return the transparentHugePageDefrag value.
     */
    public String transparentHugePageDefrag() {
        return this.transparentHugePageDefrag;
    }

    /**
     * Set the transparentHugePageDefrag property: Transparent Huge Page defrag configuration.
     *
     * @param transparentHugePageDefrag the transparentHugePageDefrag value to set.
     * @return the LinuxOSConfig object itself.
     */
    public LinuxOSConfig withTransparentHugePageDefrag(String transparentHugePageDefrag) {
        this.transparentHugePageDefrag = transparentHugePageDefrag;
        return this;
    }

    /**
     * Get the swapFileSizeMB property: SwapFileSizeMB specifies size in MB of a swap file will be created on each node.
     *
     * @return the swapFileSizeMB value.
     */
    public Integer swapFileSizeMB() {
        return this.swapFileSizeMB;
    }

    /**
     * Set the swapFileSizeMB property: SwapFileSizeMB specifies size in MB of a swap file will be created on each node.
     *
     * @param swapFileSizeMB the swapFileSizeMB value to set.
     * @return the LinuxOSConfig object itself.
     */
    public LinuxOSConfig withSwapFileSizeMB(Integer swapFileSizeMB) {
        this.swapFileSizeMB = swapFileSizeMB;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sysctls() != null) {
            sysctls().validate();
        }
    }
}
