// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Access profile for managed cluster API server. */
@Fluent
public final class ManagedClusterApiServerAccessProfile {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ManagedClusterApiServerAccessProfile.class);

    /*
     * Authorized IP Ranges to kubernetes API server.
     */
    @JsonProperty(value = "authorizedIPRanges")
    private List<String> authorizedIpRanges;

    /*
     * Whether to create the cluster as a private cluster or not.
     */
    @JsonProperty(value = "enablePrivateCluster")
    private Boolean enablePrivateCluster;

    /*
     * Private dns zone mode for private cluster.
     */
    @JsonProperty(value = "privateDNSZone")
    private String privateDnsZone;

    /**
     * Get the authorizedIpRanges property: Authorized IP Ranges to kubernetes API server.
     *
     * @return the authorizedIpRanges value.
     */
    public List<String> authorizedIpRanges() {
        return this.authorizedIpRanges;
    }

    /**
     * Set the authorizedIpRanges property: Authorized IP Ranges to kubernetes API server.
     *
     * @param authorizedIpRanges the authorizedIpRanges value to set.
     * @return the ManagedClusterApiServerAccessProfile object itself.
     */
    public ManagedClusterApiServerAccessProfile withAuthorizedIpRanges(List<String> authorizedIpRanges) {
        this.authorizedIpRanges = authorizedIpRanges;
        return this;
    }

    /**
     * Get the enablePrivateCluster property: Whether to create the cluster as a private cluster or not.
     *
     * @return the enablePrivateCluster value.
     */
    public Boolean enablePrivateCluster() {
        return this.enablePrivateCluster;
    }

    /**
     * Set the enablePrivateCluster property: Whether to create the cluster as a private cluster or not.
     *
     * @param enablePrivateCluster the enablePrivateCluster value to set.
     * @return the ManagedClusterApiServerAccessProfile object itself.
     */
    public ManagedClusterApiServerAccessProfile withEnablePrivateCluster(Boolean enablePrivateCluster) {
        this.enablePrivateCluster = enablePrivateCluster;
        return this;
    }

    /**
     * Get the privateDnsZone property: Private dns zone mode for private cluster.
     *
     * @return the privateDnsZone value.
     */
    public String privateDnsZone() {
        return this.privateDnsZone;
    }

    /**
     * Set the privateDnsZone property: Private dns zone mode for private cluster.
     *
     * @param privateDnsZone the privateDnsZone value to set.
     * @return the ManagedClusterApiServerAccessProfile object itself.
     */
    public ManagedClusterApiServerAccessProfile withPrivateDnsZone(String privateDnsZone) {
        this.privateDnsZone = privateDnsZone;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
