// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Auto upgrade profile for a managed cluster. */
@Fluent
public final class ManagedClusterAutoUpgradeProfile {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ManagedClusterAutoUpgradeProfile.class);

    /*
     * upgrade channel for auto upgrade.
     */
    @JsonProperty(value = "upgradeChannel")
    private UpgradeChannel upgradeChannel;

    /**
     * Get the upgradeChannel property: upgrade channel for auto upgrade.
     *
     * @return the upgradeChannel value.
     */
    public UpgradeChannel upgradeChannel() {
        return this.upgradeChannel;
    }

    /**
     * Set the upgradeChannel property: upgrade channel for auto upgrade.
     *
     * @param upgradeChannel the upgradeChannel value to set.
     * @return the ManagedClusterAutoUpgradeProfile object itself.
     */
    public ManagedClusterAutoUpgradeProfile withUpgradeChannel(UpgradeChannel upgradeChannel) {
        this.upgradeChannel = upgradeChannel;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
