// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Configurations for provisioning the cluster with HTTP proxy servers. */
@Fluent
public final class ManagedClusterHttpProxyConfig {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ManagedClusterHttpProxyConfig.class);

    /*
     * HTTP proxy server endpoint to use.
     */
    @JsonProperty(value = "httpProxy")
    private String httpProxy;

    /*
     * HTTPS proxy server endpoint to use.
     */
    @JsonProperty(value = "httpsProxy")
    private String httpsProxy;

    /*
     * Endpoints that should not go through proxy.
     */
    @JsonProperty(value = "noProxy")
    private List<String> noProxy;

    /*
     * Alternative CA cert to use for connecting to proxy servers.
     */
    @JsonProperty(value = "trustedCa")
    private String trustedCa;

    /**
     * Get the httpProxy property: HTTP proxy server endpoint to use.
     *
     * @return the httpProxy value.
     */
    public String httpProxy() {
        return this.httpProxy;
    }

    /**
     * Set the httpProxy property: HTTP proxy server endpoint to use.
     *
     * @param httpProxy the httpProxy value to set.
     * @return the ManagedClusterHttpProxyConfig object itself.
     */
    public ManagedClusterHttpProxyConfig withHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
        return this;
    }

    /**
     * Get the httpsProxy property: HTTPS proxy server endpoint to use.
     *
     * @return the httpsProxy value.
     */
    public String httpsProxy() {
        return this.httpsProxy;
    }

    /**
     * Set the httpsProxy property: HTTPS proxy server endpoint to use.
     *
     * @param httpsProxy the httpsProxy value to set.
     * @return the ManagedClusterHttpProxyConfig object itself.
     */
    public ManagedClusterHttpProxyConfig withHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
        return this;
    }

    /**
     * Get the noProxy property: Endpoints that should not go through proxy.
     *
     * @return the noProxy value.
     */
    public List<String> noProxy() {
        return this.noProxy;
    }

    /**
     * Set the noProxy property: Endpoints that should not go through proxy.
     *
     * @param noProxy the noProxy value to set.
     * @return the ManagedClusterHttpProxyConfig object itself.
     */
    public ManagedClusterHttpProxyConfig withNoProxy(List<String> noProxy) {
        this.noProxy = noProxy;
        return this;
    }

    /**
     * Get the trustedCa property: Alternative CA cert to use for connecting to proxy servers.
     *
     * @return the trustedCa value.
     */
    public String trustedCa() {
        return this.trustedCa;
    }

    /**
     * Set the trustedCa property: Alternative CA cert to use for connecting to proxy servers.
     *
     * @param trustedCa the trustedCa value to set.
     * @return the ManagedClusterHttpProxyConfig object itself.
     */
    public ManagedClusterHttpProxyConfig withTrustedCa(String trustedCa) {
        this.trustedCa = trustedCa;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
