// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for Ossku. */
public final class Ossku extends ExpandableStringEnum<Ossku> {
    /** Static value Ubuntu for Ossku. */
    public static final Ossku UBUNTU = fromString("Ubuntu");

    /** Static value CBLMariner for Ossku. */
    public static final Ossku CBLMARINER = fromString("CBLMariner");

    /**
     * Creates or finds a Ossku from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding Ossku.
     */
    @JsonCreator
    public static Ossku fromString(String name) {
        return fromString(name, Ossku.class);
    }

    /** @return known Ossku values. */
    public static Collection<Ossku> values() {
        return values(Ossku.class);
    }
}
