// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** run command request. */
@Fluent
public final class RunCommandRequest {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RunCommandRequest.class);

    /*
     * command to run.
     */
    @JsonProperty(value = "command", required = true)
    private String command;

    /*
     * base64 encoded zip file, contains files required by the command
     */
    @JsonProperty(value = "context")
    private String context;

    /*
     * AuthToken issued for AKS AAD Server App.
     */
    @JsonProperty(value = "clusterToken")
    private String clusterToken;

    /**
     * Get the command property: command to run.
     *
     * @return the command value.
     */
    public String command() {
        return this.command;
    }

    /**
     * Set the command property: command to run.
     *
     * @param command the command value to set.
     * @return the RunCommandRequest object itself.
     */
    public RunCommandRequest withCommand(String command) {
        this.command = command;
        return this;
    }

    /**
     * Get the context property: base64 encoded zip file, contains files required by the command.
     *
     * @return the context value.
     */
    public String context() {
        return this.context;
    }

    /**
     * Set the context property: base64 encoded zip file, contains files required by the command.
     *
     * @param context the context value to set.
     * @return the RunCommandRequest object itself.
     */
    public RunCommandRequest withContext(String context) {
        this.context = context;
        return this;
    }

    /**
     * Get the clusterToken property: AuthToken issued for AKS AAD Server App.
     *
     * @return the clusterToken value.
     */
    public String clusterToken() {
        return this.clusterToken;
    }

    /**
     * Set the clusterToken property: AuthToken issued for AKS AAD Server App.
     *
     * @param clusterToken the clusterToken value to set.
     * @return the RunCommandRequest object itself.
     */
    public RunCommandRequest withClusterToken(String clusterToken) {
        this.clusterToken = clusterToken;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (command() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property command in model RunCommandRequest"));
        }
    }
}
