/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPoolUpgradeProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ManagedClusterUpgradeProfileInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ManagedClusterUpgradeProfileInner.class);
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="name", access=JsonProperty.Access.WRITE_ONLY)
    private String name;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="properties.controlPlaneProfile", required=true)
    private ManagedClusterPoolUpgradeProfile controlPlaneProfile;
    @JsonProperty(value="properties.agentPoolProfiles", required=true)
    private List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public ManagedClusterPoolUpgradeProfile controlPlaneProfile() {
        return this.controlPlaneProfile;
    }

    public ManagedClusterUpgradeProfileInner withControlPlaneProfile(ManagedClusterPoolUpgradeProfile controlPlaneProfile) {
        this.controlPlaneProfile = controlPlaneProfile;
        return this;
    }

    public List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    public ManagedClusterUpgradeProfileInner withAgentPoolProfiles(List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    public void validate() {
        if (this.controlPlaneProfile() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property controlPlaneProfile in model ManagedClusterUpgradeProfileInner"));
        }
        this.controlPlaneProfile().validate();
        if (this.agentPoolProfiles() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property agentPoolProfiles in model ManagedClusterUpgradeProfileInner"));
        }
        this.agentPoolProfiles().forEach(e -> e.validate());
    }
}

