// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem;
import java.io.IOException;
import java.util.List;

/**
 * The list of available versions for an agent pool.
 */
@Fluent
public final class AgentPoolAvailableVersionsInner implements JsonSerializable<AgentPoolAvailableVersionsInner> {
    /*
     * The ID of the agent pool version list.
     */
    private String id;

    /*
     * The name of the agent pool version list.
     */
    private String name;

    /*
     * Type of the agent pool version list.
     */
    private String type;

    /*
     * Properties of agent pool available versions.
     */
    private AgentPoolAvailableVersionsProperties innerProperties = new AgentPoolAvailableVersionsProperties();

    /**
     * Creates an instance of AgentPoolAvailableVersionsInner class.
     */
    public AgentPoolAvailableVersionsInner() {
    }

    /**
     * Get the id property: The ID of the agent pool version list.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the agent pool version list.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Type of the agent pool version list.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the innerProperties property: Properties of agent pool available versions.
     * 
     * @return the innerProperties value.
     */
    private AgentPoolAvailableVersionsProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the agentPoolVersions property: List of versions available for agent pool.
     * 
     * @return the agentPoolVersions value.
     */
    public List<AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem> agentPoolVersions() {
        return this.innerProperties() == null ? null : this.innerProperties().agentPoolVersions();
    }

    /**
     * Set the agentPoolVersions property: List of versions available for agent pool.
     * 
     * @param agentPoolVersions the agentPoolVersions value to set.
     * @return the AgentPoolAvailableVersionsInner object itself.
     */
    public AgentPoolAvailableVersionsInner
        withAgentPoolVersions(List<AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem> agentPoolVersions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AgentPoolAvailableVersionsProperties();
        }
        this.innerProperties().withAgentPoolVersions(agentPoolVersions);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model AgentPoolAvailableVersionsInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AgentPoolAvailableVersionsInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AgentPoolAvailableVersionsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AgentPoolAvailableVersionsInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AgentPoolAvailableVersionsInner.
     */
    public static AgentPoolAvailableVersionsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AgentPoolAvailableVersionsInner deserializedAgentPoolAvailableVersionsInner
                = new AgentPoolAvailableVersionsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedAgentPoolAvailableVersionsInner.innerProperties
                        = AgentPoolAvailableVersionsProperties.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedAgentPoolAvailableVersionsInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAgentPoolAvailableVersionsInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAgentPoolAvailableVersionsInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAgentPoolAvailableVersionsInner;
        });
    }
}
