// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Objects;

/**
 * A date range.
 * 
 * For example, between '2022-12-23' and '2023-01-05'.
 */
@Fluent
public final class DateSpan implements JsonSerializable<DateSpan> {
    /*
     * The start date of the date span.
     */
    private LocalDate start;

    /*
     * The end date of the date span.
     */
    private LocalDate end;

    /**
     * Creates an instance of DateSpan class.
     */
    public DateSpan() {
    }

    /**
     * Get the start property: The start date of the date span.
     * 
     * @return the start value.
     */
    public LocalDate start() {
        return this.start;
    }

    /**
     * Set the start property: The start date of the date span.
     * 
     * @param start the start value to set.
     * @return the DateSpan object itself.
     */
    public DateSpan withStart(LocalDate start) {
        this.start = start;
        return this;
    }

    /**
     * Get the end property: The end date of the date span.
     * 
     * @return the end value.
     */
    public LocalDate end() {
        return this.end;
    }

    /**
     * Set the end property: The end date of the date span.
     * 
     * @param end the end value to set.
     * @return the DateSpan object itself.
     */
    public DateSpan withEnd(LocalDate end) {
        this.end = end;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (start() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property start in model DateSpan"));
        }
        if (end() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property end in model DateSpan"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DateSpan.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("start", Objects.toString(this.start, null));
        jsonWriter.writeStringField("end", Objects.toString(this.end, null));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DateSpan from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DateSpan if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DateSpan.
     */
    public static DateSpan fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DateSpan deserializedDateSpan = new DateSpan();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("start".equals(fieldName)) {
                    deserializedDateSpan.start
                        = reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                } else if ("end".equals(fieldName)) {
                    deserializedDateSpan.end
                        = reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDateSpan;
        });
    }
}
