// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * GPU settings for the Agent Pool.
 */
@Fluent
public final class GpuProfile implements JsonSerializable<GpuProfile> {
    /*
     * Whether to install GPU drivers. When it's not specified, default is Install.
     */
    private GpuDriver driver;

    /**
     * Creates an instance of GpuProfile class.
     */
    public GpuProfile() {
    }

    /**
     * Get the driver property: Whether to install GPU drivers. When it's not specified, default is Install.
     * 
     * @return the driver value.
     */
    public GpuDriver driver() {
        return this.driver;
    }

    /**
     * Set the driver property: Whether to install GPU drivers. When it's not specified, default is Install.
     * 
     * @param driver the driver value to set.
     * @return the GpuProfile object itself.
     */
    public GpuProfile withDriver(GpuDriver driver) {
        this.driver = driver;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("driver", this.driver == null ? null : this.driver.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GpuProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GpuProfile if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the GpuProfile.
     */
    public static GpuProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GpuProfile deserializedGpuProfile = new GpuProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("driver".equals(fieldName)) {
                    deserializedGpuProfile.driver = GpuDriver.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGpuProfile;
        });
    }
}
