// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * One and only one of the schedule types should be specified. Choose either 'daily', 'weekly', 'absoluteMonthly' or
 * 'relativeMonthly' for your maintenance schedule.
 */
@Fluent
public final class Schedule implements JsonSerializable<Schedule> {
    /*
     * For schedules like: 'recur every day' or 'recur every 3 days'.
     */
    private DailySchedule daily;

    /*
     * For schedules like: 'recur every Monday' or 'recur every 3 weeks on Wednesday'.
     */
    private WeeklySchedule weekly;

    /*
     * For schedules like: 'recur every month on the 15th' or 'recur every 3 months on the 20th'.
     */
    private AbsoluteMonthlySchedule absoluteMonthly;

    /*
     * For schedules like: 'recur every month on the first Monday' or 'recur every 3 months on last Friday'.
     */
    private RelativeMonthlySchedule relativeMonthly;

    /**
     * Creates an instance of Schedule class.
     */
    public Schedule() {
    }

    /**
     * Get the daily property: For schedules like: 'recur every day' or 'recur every 3 days'.
     * 
     * @return the daily value.
     */
    public DailySchedule daily() {
        return this.daily;
    }

    /**
     * Set the daily property: For schedules like: 'recur every day' or 'recur every 3 days'.
     * 
     * @param daily the daily value to set.
     * @return the Schedule object itself.
     */
    public Schedule withDaily(DailySchedule daily) {
        this.daily = daily;
        return this;
    }

    /**
     * Get the weekly property: For schedules like: 'recur every Monday' or 'recur every 3 weeks on Wednesday'.
     * 
     * @return the weekly value.
     */
    public WeeklySchedule weekly() {
        return this.weekly;
    }

    /**
     * Set the weekly property: For schedules like: 'recur every Monday' or 'recur every 3 weeks on Wednesday'.
     * 
     * @param weekly the weekly value to set.
     * @return the Schedule object itself.
     */
    public Schedule withWeekly(WeeklySchedule weekly) {
        this.weekly = weekly;
        return this;
    }

    /**
     * Get the absoluteMonthly property: For schedules like: 'recur every month on the 15th' or 'recur every 3 months on
     * the 20th'.
     * 
     * @return the absoluteMonthly value.
     */
    public AbsoluteMonthlySchedule absoluteMonthly() {
        return this.absoluteMonthly;
    }

    /**
     * Set the absoluteMonthly property: For schedules like: 'recur every month on the 15th' or 'recur every 3 months on
     * the 20th'.
     * 
     * @param absoluteMonthly the absoluteMonthly value to set.
     * @return the Schedule object itself.
     */
    public Schedule withAbsoluteMonthly(AbsoluteMonthlySchedule absoluteMonthly) {
        this.absoluteMonthly = absoluteMonthly;
        return this;
    }

    /**
     * Get the relativeMonthly property: For schedules like: 'recur every month on the first Monday' or 'recur every 3
     * months on last Friday'.
     * 
     * @return the relativeMonthly value.
     */
    public RelativeMonthlySchedule relativeMonthly() {
        return this.relativeMonthly;
    }

    /**
     * Set the relativeMonthly property: For schedules like: 'recur every month on the first Monday' or 'recur every 3
     * months on last Friday'.
     * 
     * @param relativeMonthly the relativeMonthly value to set.
     * @return the Schedule object itself.
     */
    public Schedule withRelativeMonthly(RelativeMonthlySchedule relativeMonthly) {
        this.relativeMonthly = relativeMonthly;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (daily() != null) {
            daily().validate();
        }
        if (weekly() != null) {
            weekly().validate();
        }
        if (absoluteMonthly() != null) {
            absoluteMonthly().validate();
        }
        if (relativeMonthly() != null) {
            relativeMonthly().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("daily", this.daily);
        jsonWriter.writeJsonField("weekly", this.weekly);
        jsonWriter.writeJsonField("absoluteMonthly", this.absoluteMonthly);
        jsonWriter.writeJsonField("relativeMonthly", this.relativeMonthly);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Schedule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Schedule if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Schedule.
     */
    public static Schedule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Schedule deserializedSchedule = new Schedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("daily".equals(fieldName)) {
                    deserializedSchedule.daily = DailySchedule.fromJson(reader);
                } else if ("weekly".equals(fieldName)) {
                    deserializedSchedule.weekly = WeeklySchedule.fromJson(reader);
                } else if ("absoluteMonthly".equals(fieldName)) {
                    deserializedSchedule.absoluteMonthly = AbsoluteMonthlySchedule.fromJson(reader);
                } else if ("relativeMonthly".equals(fieldName)) {
                    deserializedSchedule.relativeMonthly = RelativeMonthlySchedule.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSchedule;
        });
    }
}
