// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Access profile for managed cluster API server.
 */
@Fluent
public final class ManagedClusterApiServerAccessProfile
    implements JsonSerializable<ManagedClusterApiServerAccessProfile> {
    /*
     * IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with clusters that
     * use Public IP Per Node, or clusters that are using a Basic Load Balancer. For more information see [API server
     * authorized IP ranges](https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges).
     */
    private List<String> authorizedIpRanges;

    /*
     * For more details, see [Creating a private AKS cluster](https://docs.microsoft.com/azure/aks/private-clusters).
     */
    private Boolean enablePrivateCluster;

    /*
     * The default is System. For more details see [configure private DNS
     * zone](https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone). Allowed values are
     * 'system' and 'none'.
     */
    private String privateDnsZone;

    /*
     * Whether to create additional public FQDN for private cluster or not.
     */
    private Boolean enablePrivateClusterPublicFqdn;

    /*
     * Whether to disable run command for the cluster or not.
     */
    private Boolean disableRunCommand;

    /*
     * Whether to enable apiserver vnet integration for the cluster or not. See aka.ms/AksVnetIntegration for more
     * details.
     */
    private Boolean enableVnetIntegration;

    /*
     * It is required when creating a new cluster with BYO Vnet, or when updating an existing cluster to enable
     * apiserver vnet integration.
     */
    private String subnetId;

    /**
     * Creates an instance of ManagedClusterApiServerAccessProfile class.
     */
    public ManagedClusterApiServerAccessProfile() {
    }

    /**
     * Get the authorizedIpRanges property: IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature
     * is not compatible with clusters that use Public IP Per Node, or clusters that are using a Basic Load Balancer.
     * For more information see [API server authorized IP
     * ranges](https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges).
     * 
     * @return the authorizedIpRanges value.
     */
    public List<String> authorizedIpRanges() {
        return this.authorizedIpRanges;
    }

    /**
     * Set the authorizedIpRanges property: IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature
     * is not compatible with clusters that use Public IP Per Node, or clusters that are using a Basic Load Balancer.
     * For more information see [API server authorized IP
     * ranges](https://docs.microsoft.com/azure/aks/api-server-authorized-ip-ranges).
     * 
     * @param authorizedIpRanges the authorizedIpRanges value to set.
     * @return the ManagedClusterApiServerAccessProfile object itself.
     */
    public ManagedClusterApiServerAccessProfile withAuthorizedIpRanges(List<String> authorizedIpRanges) {
        this.authorizedIpRanges = authorizedIpRanges;
        return this;
    }

    /**
     * Get the enablePrivateCluster property: For more details, see [Creating a private AKS
     * cluster](https://docs.microsoft.com/azure/aks/private-clusters).
     * 
     * @return the enablePrivateCluster value.
     */
    public Boolean enablePrivateCluster() {
        return this.enablePrivateCluster;
    }

    /**
     * Set the enablePrivateCluster property: For more details, see [Creating a private AKS
     * cluster](https://docs.microsoft.com/azure/aks/private-clusters).
     * 
     * @param enablePrivateCluster the enablePrivateCluster value to set.
     * @return the ManagedClusterApiServerAccessProfile object itself.
     */
    public ManagedClusterApiServerAccessProfile withEnablePrivateCluster(Boolean enablePrivateCluster) {
        this.enablePrivateCluster = enablePrivateCluster;
        return this;
    }

    /**
     * Get the privateDnsZone property: The default is System. For more details see [configure private DNS
     * zone](https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone). Allowed values are
     * 'system' and 'none'.
     * 
     * @return the privateDnsZone value.
     */
    public String privateDnsZone() {
        return this.privateDnsZone;
    }

    /**
     * Set the privateDnsZone property: The default is System. For more details see [configure private DNS
     * zone](https://docs.microsoft.com/azure/aks/private-clusters#configure-private-dns-zone). Allowed values are
     * 'system' and 'none'.
     * 
     * @param privateDnsZone the privateDnsZone value to set.
     * @return the ManagedClusterApiServerAccessProfile object itself.
     */
    public ManagedClusterApiServerAccessProfile withPrivateDnsZone(String privateDnsZone) {
        this.privateDnsZone = privateDnsZone;
        return this;
    }

    /**
     * Get the enablePrivateClusterPublicFqdn property: Whether to create additional public FQDN for private cluster or
     * not.
     * 
     * @return the enablePrivateClusterPublicFqdn value.
     */
    public Boolean enablePrivateClusterPublicFqdn() {
        return this.enablePrivateClusterPublicFqdn;
    }

    /**
     * Set the enablePrivateClusterPublicFqdn property: Whether to create additional public FQDN for private cluster or
     * not.
     * 
     * @param enablePrivateClusterPublicFqdn the enablePrivateClusterPublicFqdn value to set.
     * @return the ManagedClusterApiServerAccessProfile object itself.
     */
    public ManagedClusterApiServerAccessProfile
        withEnablePrivateClusterPublicFqdn(Boolean enablePrivateClusterPublicFqdn) {
        this.enablePrivateClusterPublicFqdn = enablePrivateClusterPublicFqdn;
        return this;
    }

    /**
     * Get the disableRunCommand property: Whether to disable run command for the cluster or not.
     * 
     * @return the disableRunCommand value.
     */
    public Boolean disableRunCommand() {
        return this.disableRunCommand;
    }

    /**
     * Set the disableRunCommand property: Whether to disable run command for the cluster or not.
     * 
     * @param disableRunCommand the disableRunCommand value to set.
     * @return the ManagedClusterApiServerAccessProfile object itself.
     */
    public ManagedClusterApiServerAccessProfile withDisableRunCommand(Boolean disableRunCommand) {
        this.disableRunCommand = disableRunCommand;
        return this;
    }

    /**
     * Get the enableVnetIntegration property: Whether to enable apiserver vnet integration for the cluster or not. See
     * aka.ms/AksVnetIntegration for more details.
     * 
     * @return the enableVnetIntegration value.
     */
    public Boolean enableVnetIntegration() {
        return this.enableVnetIntegration;
    }

    /**
     * Set the enableVnetIntegration property: Whether to enable apiserver vnet integration for the cluster or not. See
     * aka.ms/AksVnetIntegration for more details.
     * 
     * @param enableVnetIntegration the enableVnetIntegration value to set.
     * @return the ManagedClusterApiServerAccessProfile object itself.
     */
    public ManagedClusterApiServerAccessProfile withEnableVnetIntegration(Boolean enableVnetIntegration) {
        this.enableVnetIntegration = enableVnetIntegration;
        return this;
    }

    /**
     * Get the subnetId property: It is required when creating a new cluster with BYO Vnet, or when updating an existing
     * cluster to enable apiserver vnet integration.
     * 
     * @return the subnetId value.
     */
    public String subnetId() {
        return this.subnetId;
    }

    /**
     * Set the subnetId property: It is required when creating a new cluster with BYO Vnet, or when updating an existing
     * cluster to enable apiserver vnet integration.
     * 
     * @param subnetId the subnetId value to set.
     * @return the ManagedClusterApiServerAccessProfile object itself.
     */
    public ManagedClusterApiServerAccessProfile withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("authorizedIPRanges", this.authorizedIpRanges,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("enablePrivateCluster", this.enablePrivateCluster);
        jsonWriter.writeStringField("privateDNSZone", this.privateDnsZone);
        jsonWriter.writeBooleanField("enablePrivateClusterPublicFQDN", this.enablePrivateClusterPublicFqdn);
        jsonWriter.writeBooleanField("disableRunCommand", this.disableRunCommand);
        jsonWriter.writeBooleanField("enableVnetIntegration", this.enableVnetIntegration);
        jsonWriter.writeStringField("subnetId", this.subnetId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterApiServerAccessProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterApiServerAccessProfile if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterApiServerAccessProfile.
     */
    public static ManagedClusterApiServerAccessProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterApiServerAccessProfile deserializedManagedClusterApiServerAccessProfile
                = new ManagedClusterApiServerAccessProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("authorizedIPRanges".equals(fieldName)) {
                    List<String> authorizedIpRanges = reader.readArray(reader1 -> reader1.getString());
                    deserializedManagedClusterApiServerAccessProfile.authorizedIpRanges = authorizedIpRanges;
                } else if ("enablePrivateCluster".equals(fieldName)) {
                    deserializedManagedClusterApiServerAccessProfile.enablePrivateCluster
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("privateDNSZone".equals(fieldName)) {
                    deserializedManagedClusterApiServerAccessProfile.privateDnsZone = reader.getString();
                } else if ("enablePrivateClusterPublicFQDN".equals(fieldName)) {
                    deserializedManagedClusterApiServerAccessProfile.enablePrivateClusterPublicFqdn
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("disableRunCommand".equals(fieldName)) {
                    deserializedManagedClusterApiServerAccessProfile.disableRunCommand
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableVnetIntegration".equals(fieldName)) {
                    deserializedManagedClusterApiServerAccessProfile.enableVnetIntegration
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("subnetId".equals(fieldName)) {
                    deserializedManagedClusterApiServerAccessProfile.subnetId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterApiServerAccessProfile;
        });
    }
}
