// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ManagedClusterIngressProfileNginx model.
 */
@Fluent
public final class ManagedClusterIngressProfileNginx implements JsonSerializable<ManagedClusterIngressProfileNginx> {
    /*
     * Ingress type for the default NginxIngressController custom resource
     */
    private NginxIngressControllerType defaultIngressControllerType;

    /**
     * Creates an instance of ManagedClusterIngressProfileNginx class.
     */
    public ManagedClusterIngressProfileNginx() {
    }

    /**
     * Get the defaultIngressControllerType property: Ingress type for the default NginxIngressController custom
     * resource.
     * 
     * @return the defaultIngressControllerType value.
     */
    public NginxIngressControllerType defaultIngressControllerType() {
        return this.defaultIngressControllerType;
    }

    /**
     * Set the defaultIngressControllerType property: Ingress type for the default NginxIngressController custom
     * resource.
     * 
     * @param defaultIngressControllerType the defaultIngressControllerType value to set.
     * @return the ManagedClusterIngressProfileNginx object itself.
     */
    public ManagedClusterIngressProfileNginx
        withDefaultIngressControllerType(NginxIngressControllerType defaultIngressControllerType) {
        this.defaultIngressControllerType = defaultIngressControllerType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultIngressControllerType",
            this.defaultIngressControllerType == null ? null : this.defaultIngressControllerType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterIngressProfileNginx from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterIngressProfileNginx if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterIngressProfileNginx.
     */
    public static ManagedClusterIngressProfileNginx fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterIngressProfileNginx deserializedManagedClusterIngressProfileNginx
                = new ManagedClusterIngressProfileNginx();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("defaultIngressControllerType".equals(fieldName)) {
                    deserializedManagedClusterIngressProfileNginx.defaultIngressControllerType
                        = NginxIngressControllerType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterIngressProfileNginx;
        });
    }
}
