// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The list of available upgrade versions.
 */
@Fluent
public final class ManagedClusterPoolUpgradeProfile implements JsonSerializable<ManagedClusterPoolUpgradeProfile> {
    /*
     * The Kubernetes version (major.minor.patch).
     */
    private String kubernetesVersion;

    /*
     * The Agent Pool name.
     */
    private String name;

    /*
     * OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     */
    private OSType osType;

    /*
     * List of orchestrator types and versions available for upgrade.
     */
    private List<ManagedClusterPoolUpgradeProfileUpgradesItem> upgrades;

    /**
     * Creates an instance of ManagedClusterPoolUpgradeProfile class.
     */
    public ManagedClusterPoolUpgradeProfile() {
    }

    /**
     * Get the kubernetesVersion property: The Kubernetes version (major.minor.patch).
     * 
     * @return the kubernetesVersion value.
     */
    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    /**
     * Set the kubernetesVersion property: The Kubernetes version (major.minor.patch).
     * 
     * @param kubernetesVersion the kubernetesVersion value to set.
     * @return the ManagedClusterPoolUpgradeProfile object itself.
     */
    public ManagedClusterPoolUpgradeProfile withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    /**
     * Get the name property: The Agent Pool name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The Agent Pool name.
     * 
     * @param name the name value to set.
     * @return the ManagedClusterPoolUpgradeProfile object itself.
     */
    public ManagedClusterPoolUpgradeProfile withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @return the osType value.
     */
    public OSType osType() {
        return this.osType;
    }

    /**
     * Set the osType property: OsType to be used to specify os type. Choose from Linux and Windows. Default to Linux.
     * 
     * @param osType the osType value to set.
     * @return the ManagedClusterPoolUpgradeProfile object itself.
     */
    public ManagedClusterPoolUpgradeProfile withOsType(OSType osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the upgrades property: List of orchestrator types and versions available for upgrade.
     * 
     * @return the upgrades value.
     */
    public List<ManagedClusterPoolUpgradeProfileUpgradesItem> upgrades() {
        return this.upgrades;
    }

    /**
     * Set the upgrades property: List of orchestrator types and versions available for upgrade.
     * 
     * @param upgrades the upgrades value to set.
     * @return the ManagedClusterPoolUpgradeProfile object itself.
     */
    public ManagedClusterPoolUpgradeProfile withUpgrades(List<ManagedClusterPoolUpgradeProfileUpgradesItem> upgrades) {
        this.upgrades = upgrades;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (kubernetesVersion() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property kubernetesVersion in model ManagedClusterPoolUpgradeProfile"));
        }
        if (osType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property osType in model ManagedClusterPoolUpgradeProfile"));
        }
        if (upgrades() != null) {
            upgrades().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterPoolUpgradeProfile.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kubernetesVersion", this.kubernetesVersion);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("upgrades", this.upgrades, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterPoolUpgradeProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterPoolUpgradeProfile if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedClusterPoolUpgradeProfile.
     */
    public static ManagedClusterPoolUpgradeProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterPoolUpgradeProfile deserializedManagedClusterPoolUpgradeProfile
                = new ManagedClusterPoolUpgradeProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedManagedClusterPoolUpgradeProfile.kubernetesVersion = reader.getString();
                } else if ("osType".equals(fieldName)) {
                    deserializedManagedClusterPoolUpgradeProfile.osType = OSType.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedManagedClusterPoolUpgradeProfile.name = reader.getString();
                } else if ("upgrades".equals(fieldName)) {
                    List<ManagedClusterPoolUpgradeProfileUpgradesItem> upgrades
                        = reader.readArray(reader1 -> ManagedClusterPoolUpgradeProfileUpgradesItem.fromJson(reader1));
                    deserializedManagedClusterPoolUpgradeProfile.upgrades = upgrades;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterPoolUpgradeProfile;
        });
    }
}
