// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The Static Egress Gateway addon configuration for the cluster.
 */
@Fluent
public final class ManagedClusterStaticEgressGatewayProfile
    implements JsonSerializable<ManagedClusterStaticEgressGatewayProfile> {
    /*
     * Indicates if Static Egress Gateway addon is enabled or not.
     */
    private Boolean enabled;

    /**
     * Creates an instance of ManagedClusterStaticEgressGatewayProfile class.
     */
    public ManagedClusterStaticEgressGatewayProfile() {
    }

    /**
     * Get the enabled property: Indicates if Static Egress Gateway addon is enabled or not.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates if Static Egress Gateway addon is enabled or not.
     * 
     * @param enabled the enabled value to set.
     * @return the ManagedClusterStaticEgressGatewayProfile object itself.
     */
    public ManagedClusterStaticEgressGatewayProfile withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterStaticEgressGatewayProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterStaticEgressGatewayProfile if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterStaticEgressGatewayProfile.
     */
    public static ManagedClusterStaticEgressGatewayProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterStaticEgressGatewayProfile deserializedManagedClusterStaticEgressGatewayProfile
                = new ManagedClusterStaticEgressGatewayProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedManagedClusterStaticEgressGatewayProfile.enabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterStaticEgressGatewayProfile;
        });
    }
}
