// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifications on number of machines.
 */
@Fluent
public final class ManualScaleProfile implements JsonSerializable<ManualScaleProfile> {
    /*
     * VM size that AKS will use when creating and scaling e.g. 'Standard_E4s_v3', 'Standard_E16s_v3' or
     * 'Standard_D16s_v5'.
     */
    private String size;

    /*
     * Number of nodes.
     */
    private Integer count;

    /**
     * Creates an instance of ManualScaleProfile class.
     */
    public ManualScaleProfile() {
    }

    /**
     * Get the size property: VM size that AKS will use when creating and scaling e.g. 'Standard_E4s_v3',
     * 'Standard_E16s_v3' or 'Standard_D16s_v5'.
     * 
     * @return the size value.
     */
    public String size() {
        return this.size;
    }

    /**
     * Set the size property: VM size that AKS will use when creating and scaling e.g. 'Standard_E4s_v3',
     * 'Standard_E16s_v3' or 'Standard_D16s_v5'.
     * 
     * @param size the size value to set.
     * @return the ManualScaleProfile object itself.
     */
    public ManualScaleProfile withSize(String size) {
        this.size = size;
        return this;
    }

    /**
     * Get the count property: Number of nodes.
     * 
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count property: Number of nodes.
     * 
     * @param count the count value to set.
     * @return the ManualScaleProfile object itself.
     */
    public ManualScaleProfile withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("size", this.size);
        jsonWriter.writeNumberField("count", this.count);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManualScaleProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManualScaleProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManualScaleProfile.
     */
    public static ManualScaleProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManualScaleProfile deserializedManualScaleProfile = new ManualScaleProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("size".equals(fieldName)) {
                    deserializedManualScaleProfile.size = reader.getString();
                } else if ("count".equals(fieldName)) {
                    deserializedManualScaleProfile.count = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManualScaleProfile;
        });
    }
}
