// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifications on how to scale a VirtualMachines agent pool.
 */
@Fluent
public final class ScaleProfile implements JsonSerializable<ScaleProfile> {
    /*
     * Specifications on how to scale the VirtualMachines agent pool to a fixed size.
     */
    private List<ManualScaleProfile> manual;

    /**
     * Creates an instance of ScaleProfile class.
     */
    public ScaleProfile() {
    }

    /**
     * Get the manual property: Specifications on how to scale the VirtualMachines agent pool to a fixed size.
     * 
     * @return the manual value.
     */
    public List<ManualScaleProfile> manual() {
        return this.manual;
    }

    /**
     * Set the manual property: Specifications on how to scale the VirtualMachines agent pool to a fixed size.
     * 
     * @param manual the manual value to set.
     * @return the ScaleProfile object itself.
     */
    public ScaleProfile withManual(List<ManualScaleProfile> manual) {
        this.manual = manual;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (manual() != null) {
            manual().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("manual", this.manual, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScaleProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScaleProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ScaleProfile.
     */
    public static ScaleProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScaleProfile deserializedScaleProfile = new ScaleProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("manual".equals(fieldName)) {
                    List<ManualScaleProfile> manual = reader.readArray(reader1 -> ManualScaleProfile.fromJson(reader1));
                    deserializedScaleProfile.manual = manual;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScaleProfile;
        });
    }
}
