/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.ContainerServiceSshConfiguration;
import java.io.IOException;

public final class ContainerServiceLinuxProfile
implements JsonSerializable<ContainerServiceLinuxProfile> {
    private String adminUsername;
    private ContainerServiceSshConfiguration ssh;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerServiceLinuxProfile.class);

    public String adminUsername() {
        return this.adminUsername;
    }

    public ContainerServiceLinuxProfile withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return this;
    }

    public ContainerServiceSshConfiguration ssh() {
        return this.ssh;
    }

    public ContainerServiceLinuxProfile withSsh(ContainerServiceSshConfiguration ssh) {
        this.ssh = ssh;
        return this;
    }

    public void validate() {
        if (this.adminUsername() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property adminUsername in model ContainerServiceLinuxProfile"));
        }
        if (this.ssh() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ssh in model ContainerServiceLinuxProfile"));
        }
        this.ssh().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("adminUsername", this.adminUsername);
        jsonWriter.writeJsonField("ssh", (JsonSerializable)this.ssh);
        return jsonWriter.writeEndObject();
    }

    public static ContainerServiceLinuxProfile fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerServiceLinuxProfile)jsonReader.readObject(reader -> {
            ContainerServiceLinuxProfile deserializedContainerServiceLinuxProfile = new ContainerServiceLinuxProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("adminUsername".equals(fieldName)) {
                    deserializedContainerServiceLinuxProfile.adminUsername = reader.getString();
                    continue;
                }
                if ("ssh".equals(fieldName)) {
                    deserializedContainerServiceLinuxProfile.ssh = ContainerServiceSshConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerServiceLinuxProfile;
        });
    }
}

