/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.KeyVaultNetworkAccessTypes;
import java.io.IOException;

public final class AzureKeyVaultKms
implements JsonSerializable<AzureKeyVaultKms> {
    private Boolean enabled;
    private String keyId;
    private KeyVaultNetworkAccessTypes keyVaultNetworkAccess;
    private String keyVaultResourceId;

    public Boolean enabled() {
        return this.enabled;
    }

    public AzureKeyVaultKms withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String keyId() {
        return this.keyId;
    }

    public AzureKeyVaultKms withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public KeyVaultNetworkAccessTypes keyVaultNetworkAccess() {
        return this.keyVaultNetworkAccess;
    }

    public AzureKeyVaultKms withKeyVaultNetworkAccess(KeyVaultNetworkAccessTypes keyVaultNetworkAccess) {
        this.keyVaultNetworkAccess = keyVaultNetworkAccess;
        return this;
    }

    public String keyVaultResourceId() {
        return this.keyVaultResourceId;
    }

    public AzureKeyVaultKms withKeyVaultResourceId(String keyVaultResourceId) {
        this.keyVaultResourceId = keyVaultResourceId;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("keyId", this.keyId);
        jsonWriter.writeStringField("keyVaultNetworkAccess", this.keyVaultNetworkAccess == null ? null : this.keyVaultNetworkAccess.toString());
        jsonWriter.writeStringField("keyVaultResourceId", this.keyVaultResourceId);
        return jsonWriter.writeEndObject();
    }

    public static AzureKeyVaultKms fromJson(JsonReader jsonReader) throws IOException {
        return (AzureKeyVaultKms)jsonReader.readObject(reader -> {
            AzureKeyVaultKms deserializedAzureKeyVaultKms = new AzureKeyVaultKms();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedAzureKeyVaultKms.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("keyId".equals(fieldName)) {
                    deserializedAzureKeyVaultKms.keyId = reader.getString();
                    continue;
                }
                if ("keyVaultNetworkAccess".equals(fieldName)) {
                    deserializedAzureKeyVaultKms.keyVaultNetworkAccess = KeyVaultNetworkAccessTypes.fromString(reader.getString());
                    continue;
                }
                if ("keyVaultResourceId".equals(fieldName)) {
                    deserializedAzureKeyVaultKms.keyVaultResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureKeyVaultKms;
        });
    }
}

