// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The load balancer sku for the managed cluster. The default is 'standard'. See [Azure Load Balancer
 * SKUs](https://docs.microsoft.com/azure/load-balancer/skus) for more information about the differences between load
 * balancer SKUs.
 */
public final class LoadBalancerSku extends ExpandableStringEnum<LoadBalancerSku> {
    /**
     * Static value standard for LoadBalancerSku.
     */
    public static final LoadBalancerSku STANDARD = fromString("standard");

    /**
     * Static value basic for LoadBalancerSku.
     */
    public static final LoadBalancerSku BASIC = fromString("basic");

    /**
     * Creates a new instance of LoadBalancerSku value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LoadBalancerSku() {
    }

    /**
     * Creates or finds a LoadBalancerSku from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding LoadBalancerSku.
     */
    public static LoadBalancerSku fromString(String name) {
        return fromString(name, LoadBalancerSku.class);
    }

    /**
     * Gets known LoadBalancerSku values.
     * 
     * @return known LoadBalancerSku values.
     */
    public static Collection<LoadBalancerSku> values() {
        return values(LoadBalancerSku.class);
    }
}
