// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Details about the pod identity assigned to the Managed Cluster.
 */
@Fluent
public final class ManagedClusterPodIdentity implements JsonSerializable<ManagedClusterPodIdentity> {
    /*
     * The name of the pod identity.
     */
    private String name;

    /*
     * The namespace of the pod identity.
     */
    private String namespace;

    /*
     * The binding selector to use for the AzureIdentityBinding resource.
     */
    private String bindingSelector;

    /*
     * The user assigned identity details.
     */
    private UserAssignedIdentity identity;

    /*
     * The current provisioning state of the pod identity.
     */
    private ManagedClusterPodIdentityProvisioningState provisioningState;

    /*
     * The provisioningInfo property.
     */
    private ManagedClusterPodIdentityProvisioningInfo provisioningInfo;

    /**
     * Creates an instance of ManagedClusterPodIdentity class.
     */
    public ManagedClusterPodIdentity() {
    }

    /**
     * Get the name property: The name of the pod identity.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the pod identity.
     * 
     * @param name the name value to set.
     * @return the ManagedClusterPodIdentity object itself.
     */
    public ManagedClusterPodIdentity withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the namespace property: The namespace of the pod identity.
     * 
     * @return the namespace value.
     */
    public String namespace() {
        return this.namespace;
    }

    /**
     * Set the namespace property: The namespace of the pod identity.
     * 
     * @param namespace the namespace value to set.
     * @return the ManagedClusterPodIdentity object itself.
     */
    public ManagedClusterPodIdentity withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    /**
     * Get the bindingSelector property: The binding selector to use for the AzureIdentityBinding resource.
     * 
     * @return the bindingSelector value.
     */
    public String bindingSelector() {
        return this.bindingSelector;
    }

    /**
     * Set the bindingSelector property: The binding selector to use for the AzureIdentityBinding resource.
     * 
     * @param bindingSelector the bindingSelector value to set.
     * @return the ManagedClusterPodIdentity object itself.
     */
    public ManagedClusterPodIdentity withBindingSelector(String bindingSelector) {
        this.bindingSelector = bindingSelector;
        return this;
    }

    /**
     * Get the identity property: The user assigned identity details.
     * 
     * @return the identity value.
     */
    public UserAssignedIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The user assigned identity details.
     * 
     * @param identity the identity value to set.
     * @return the ManagedClusterPodIdentity object itself.
     */
    public ManagedClusterPodIdentity withIdentity(UserAssignedIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the provisioningState property: The current provisioning state of the pod identity.
     * 
     * @return the provisioningState value.
     */
    public ManagedClusterPodIdentityProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the provisioningInfo property: The provisioningInfo property.
     * 
     * @return the provisioningInfo value.
     */
    public ManagedClusterPodIdentityProvisioningInfo provisioningInfo() {
        return this.provisioningInfo;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model ManagedClusterPodIdentity"));
        }
        if (namespace() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property namespace in model ManagedClusterPodIdentity"));
        }
        if (identity() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property identity in model ManagedClusterPodIdentity"));
        } else {
            identity().validate();
        }
        if (provisioningInfo() != null) {
            provisioningInfo().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterPodIdentity.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeStringField("bindingSelector", this.bindingSelector);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterPodIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterPodIdentity if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedClusterPodIdentity.
     */
    public static ManagedClusterPodIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterPodIdentity deserializedManagedClusterPodIdentity = new ManagedClusterPodIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedManagedClusterPodIdentity.name = reader.getString();
                } else if ("namespace".equals(fieldName)) {
                    deserializedManagedClusterPodIdentity.namespace = reader.getString();
                } else if ("identity".equals(fieldName)) {
                    deserializedManagedClusterPodIdentity.identity = UserAssignedIdentity.fromJson(reader);
                } else if ("bindingSelector".equals(fieldName)) {
                    deserializedManagedClusterPodIdentity.bindingSelector = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedManagedClusterPodIdentity.provisioningState
                        = ManagedClusterPodIdentityProvisioningState.fromString(reader.getString());
                } else if ("provisioningInfo".equals(fieldName)) {
                    deserializedManagedClusterPodIdentity.provisioningInfo
                        = ManagedClusterPodIdentityProvisioningInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterPodIdentity;
        });
    }
}
