// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.fluent.models.MeshRevisionProfileInner;
import java.io.IOException;
import java.util.List;

/**
 * Holds an array of MeshRevisionsProfiles.
 */
@Fluent
public final class MeshRevisionProfileList implements JsonSerializable<MeshRevisionProfileList> {
    /*
     * Array of service mesh add-on revision profiles for all supported mesh modes.
     */
    private List<MeshRevisionProfileInner> value;

    /*
     * The URL to get the next set of mesh revision profile.
     */
    private String nextLink;

    /**
     * Creates an instance of MeshRevisionProfileList class.
     */
    public MeshRevisionProfileList() {
    }

    /**
     * Get the value property: Array of service mesh add-on revision profiles for all supported mesh modes.
     * 
     * @return the value value.
     */
    public List<MeshRevisionProfileInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Array of service mesh add-on revision profiles for all supported mesh modes.
     * 
     * @param value the value value to set.
     * @return the MeshRevisionProfileList object itself.
     */
    public MeshRevisionProfileList withValue(List<MeshRevisionProfileInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of mesh revision profile.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MeshRevisionProfileList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MeshRevisionProfileList if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MeshRevisionProfileList.
     */
    public static MeshRevisionProfileList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MeshRevisionProfileList deserializedMeshRevisionProfileList = new MeshRevisionProfileList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<MeshRevisionProfileInner> value
                        = reader.readArray(reader1 -> MeshRevisionProfileInner.fromJson(reader1));
                    deserializedMeshRevisionProfileList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedMeshRevisionProfileList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMeshRevisionProfileList;
        });
    }
}
