// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Network plugin used for building the Kubernetes network.
 */
public final class NetworkPlugin extends ExpandableStringEnum<NetworkPlugin> {
    /**
     * Static value azure for NetworkPlugin.
     */
    public static final NetworkPlugin AZURE = fromString("azure");

    /**
     * Static value kubenet for NetworkPlugin.
     */
    public static final NetworkPlugin KUBENET = fromString("kubenet");

    /**
     * Static value none for NetworkPlugin.
     */
    public static final NetworkPlugin NONE = fromString("none");

    /**
     * Creates a new instance of NetworkPlugin value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NetworkPlugin() {
    }

    /**
     * Creates or finds a NetworkPlugin from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NetworkPlugin.
     */
    public static NetworkPlugin fromString(String name) {
        return fromString(name, NetworkPlugin.class);
    }

    /**
     * Gets known NetworkPlugin values.
     * 
     * @return known NetworkPlugin values.
     */
    public static Collection<NetworkPlugin> values() {
        return values(NetworkPlugin.class);
    }
}
