// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.NetworkProfile;
import com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterAgentPoolProfile;
import com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterAuthProfile;
import com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterMasterPoolProfile;
import com.azure.resourcemanager.containerservice.models.OpenShiftRouterProfile;
import java.io.IOException;
import java.util.List;

/**
 * Properties of the OpenShift managed cluster.
 */
@Fluent
public final class OpenShiftManagedClusterProperties implements JsonSerializable<OpenShiftManagedClusterProperties> {
    /*
     * The current deployment or provisioning state, which only appears in the response.
     */
    private String provisioningState;

    /*
     * Version of OpenShift specified when creating the cluster.
     */
    private String openShiftVersion;

    /*
     * Version of OpenShift specified when creating the cluster.
     */
    private String clusterVersion;

    /*
     * Service generated FQDN for OpenShift API server.
     */
    private String publicHostname;

    /*
     * Service generated FQDN for OpenShift API server loadbalancer internal hostname.
     */
    private String fqdn;

    /*
     * Configuration for OpenShift networking.
     */
    private NetworkProfile networkProfile;

    /*
     * Configuration for OpenShift router(s).
     */
    private List<OpenShiftRouterProfile> routerProfiles;

    /*
     * Configuration for OpenShift master VMs.
     */
    private OpenShiftManagedClusterMasterPoolProfile masterPoolProfile;

    /*
     * Configuration of OpenShift cluster VMs.
     */
    private List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles;

    /*
     * Configures OpenShift authentication.
     */
    private OpenShiftManagedClusterAuthProfile authProfile;

    /**
     * Creates an instance of OpenShiftManagedClusterProperties class.
     */
    public OpenShiftManagedClusterProperties() {
    }

    /**
     * Get the provisioningState property: The current deployment or provisioning state, which only appears in the
     * response.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the openShiftVersion property: Version of OpenShift specified when creating the cluster.
     * 
     * @return the openShiftVersion value.
     */
    public String openShiftVersion() {
        return this.openShiftVersion;
    }

    /**
     * Set the openShiftVersion property: Version of OpenShift specified when creating the cluster.
     * 
     * @param openShiftVersion the openShiftVersion value to set.
     * @return the OpenShiftManagedClusterProperties object itself.
     */
    public OpenShiftManagedClusterProperties withOpenShiftVersion(String openShiftVersion) {
        this.openShiftVersion = openShiftVersion;
        return this;
    }

    /**
     * Get the clusterVersion property: Version of OpenShift specified when creating the cluster.
     * 
     * @return the clusterVersion value.
     */
    public String clusterVersion() {
        return this.clusterVersion;
    }

    /**
     * Get the publicHostname property: Service generated FQDN for OpenShift API server.
     * 
     * @return the publicHostname value.
     */
    public String publicHostname() {
        return this.publicHostname;
    }

    /**
     * Get the fqdn property: Service generated FQDN for OpenShift API server loadbalancer internal hostname.
     * 
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Get the networkProfile property: Configuration for OpenShift networking.
     * 
     * @return the networkProfile value.
     */
    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    /**
     * Set the networkProfile property: Configuration for OpenShift networking.
     * 
     * @param networkProfile the networkProfile value to set.
     * @return the OpenShiftManagedClusterProperties object itself.
     */
    public OpenShiftManagedClusterProperties withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    /**
     * Get the routerProfiles property: Configuration for OpenShift router(s).
     * 
     * @return the routerProfiles value.
     */
    public List<OpenShiftRouterProfile> routerProfiles() {
        return this.routerProfiles;
    }

    /**
     * Set the routerProfiles property: Configuration for OpenShift router(s).
     * 
     * @param routerProfiles the routerProfiles value to set.
     * @return the OpenShiftManagedClusterProperties object itself.
     */
    public OpenShiftManagedClusterProperties withRouterProfiles(List<OpenShiftRouterProfile> routerProfiles) {
        this.routerProfiles = routerProfiles;
        return this;
    }

    /**
     * Get the masterPoolProfile property: Configuration for OpenShift master VMs.
     * 
     * @return the masterPoolProfile value.
     */
    public OpenShiftManagedClusterMasterPoolProfile masterPoolProfile() {
        return this.masterPoolProfile;
    }

    /**
     * Set the masterPoolProfile property: Configuration for OpenShift master VMs.
     * 
     * @param masterPoolProfile the masterPoolProfile value to set.
     * @return the OpenShiftManagedClusterProperties object itself.
     */
    public OpenShiftManagedClusterProperties
        withMasterPoolProfile(OpenShiftManagedClusterMasterPoolProfile masterPoolProfile) {
        this.masterPoolProfile = masterPoolProfile;
        return this;
    }

    /**
     * Get the agentPoolProfiles property: Configuration of OpenShift cluster VMs.
     * 
     * @return the agentPoolProfiles value.
     */
    public List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    /**
     * Set the agentPoolProfiles property: Configuration of OpenShift cluster VMs.
     * 
     * @param agentPoolProfiles the agentPoolProfiles value to set.
     * @return the OpenShiftManagedClusterProperties object itself.
     */
    public OpenShiftManagedClusterProperties
        withAgentPoolProfiles(List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    /**
     * Get the authProfile property: Configures OpenShift authentication.
     * 
     * @return the authProfile value.
     */
    public OpenShiftManagedClusterAuthProfile authProfile() {
        return this.authProfile;
    }

    /**
     * Set the authProfile property: Configures OpenShift authentication.
     * 
     * @param authProfile the authProfile value to set.
     * @return the OpenShiftManagedClusterProperties object itself.
     */
    public OpenShiftManagedClusterProperties withAuthProfile(OpenShiftManagedClusterAuthProfile authProfile) {
        this.authProfile = authProfile;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (openShiftVersion() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property openShiftVersion in model OpenShiftManagedClusterProperties"));
        }
        if (networkProfile() != null) {
            networkProfile().validate();
        }
        if (routerProfiles() != null) {
            routerProfiles().forEach(e -> e.validate());
        }
        if (masterPoolProfile() != null) {
            masterPoolProfile().validate();
        }
        if (agentPoolProfiles() != null) {
            agentPoolProfiles().forEach(e -> e.validate());
        }
        if (authProfile() != null) {
            authProfile().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OpenShiftManagedClusterProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("openShiftVersion", this.openShiftVersion);
        jsonWriter.writeJsonField("networkProfile", this.networkProfile);
        jsonWriter.writeArrayField("routerProfiles", this.routerProfiles,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("masterPoolProfile", this.masterPoolProfile);
        jsonWriter.writeArrayField("agentPoolProfiles", this.agentPoolProfiles,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("authProfile", this.authProfile);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenShiftManagedClusterProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenShiftManagedClusterProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OpenShiftManagedClusterProperties.
     */
    public static OpenShiftManagedClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenShiftManagedClusterProperties deserializedOpenShiftManagedClusterProperties
                = new OpenShiftManagedClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("openShiftVersion".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.openShiftVersion = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.provisioningState = reader.getString();
                } else if ("clusterVersion".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.clusterVersion = reader.getString();
                } else if ("publicHostname".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.publicHostname = reader.getString();
                } else if ("fqdn".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.fqdn = reader.getString();
                } else if ("networkProfile".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.networkProfile = NetworkProfile.fromJson(reader);
                } else if ("routerProfiles".equals(fieldName)) {
                    List<OpenShiftRouterProfile> routerProfiles
                        = reader.readArray(reader1 -> OpenShiftRouterProfile.fromJson(reader1));
                    deserializedOpenShiftManagedClusterProperties.routerProfiles = routerProfiles;
                } else if ("masterPoolProfile".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.masterPoolProfile
                        = OpenShiftManagedClusterMasterPoolProfile.fromJson(reader);
                } else if ("agentPoolProfiles".equals(fieldName)) {
                    List<OpenShiftManagedClusterAgentPoolProfile> agentPoolProfiles
                        = reader.readArray(reader1 -> OpenShiftManagedClusterAgentPoolProfile.fromJson(reader1));
                    deserializedOpenShiftManagedClusterProperties.agentPoolProfiles = agentPoolProfiles;
                } else if ("authProfile".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterProperties.authProfile
                        = OpenShiftManagedClusterAuthProfile.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOpenShiftManagedClusterProperties;
        });
    }
}
