// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Settings for upgrading a cluster.
 */
@Fluent
public final class ClusterUpgradeSettings implements JsonSerializable<ClusterUpgradeSettings> {
    /*
     * Settings for overrides.
     */
    private UpgradeOverrideSettings overrideSettings;

    /**
     * Creates an instance of ClusterUpgradeSettings class.
     */
    public ClusterUpgradeSettings() {
    }

    /**
     * Get the overrideSettings property: Settings for overrides.
     * 
     * @return the overrideSettings value.
     */
    public UpgradeOverrideSettings overrideSettings() {
        return this.overrideSettings;
    }

    /**
     * Set the overrideSettings property: Settings for overrides.
     * 
     * @param overrideSettings the overrideSettings value to set.
     * @return the ClusterUpgradeSettings object itself.
     */
    public ClusterUpgradeSettings withOverrideSettings(UpgradeOverrideSettings overrideSettings) {
        this.overrideSettings = overrideSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (overrideSettings() != null) {
            overrideSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("overrideSettings", this.overrideSettings);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClusterUpgradeSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClusterUpgradeSettings if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClusterUpgradeSettings.
     */
    public static ClusterUpgradeSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClusterUpgradeSettings deserializedClusterUpgradeSettings = new ClusterUpgradeSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("overrideSettings".equals(fieldName)) {
                    deserializedClusterUpgradeSettings.overrideSettings = UpgradeOverrideSettings.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedClusterUpgradeSettings;
        });
    }
}
