// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Plugin certificates information for Service Mesh.
 */
@Fluent
public final class IstioPluginCertificateAuthority implements JsonSerializable<IstioPluginCertificateAuthority> {
    /*
     * The resource ID of the Key Vault.
     */
    private String keyVaultId;

    /*
     * Intermediate certificate object name in Azure Key Vault.
     */
    private String certObjectName;

    /*
     * Intermediate certificate private key object name in Azure Key Vault.
     */
    private String keyObjectName;

    /*
     * Root certificate object name in Azure Key Vault.
     */
    private String rootCertObjectName;

    /*
     * Certificate chain object name in Azure Key Vault.
     */
    private String certChainObjectName;

    /**
     * Creates an instance of IstioPluginCertificateAuthority class.
     */
    public IstioPluginCertificateAuthority() {
    }

    /**
     * Get the keyVaultId property: The resource ID of the Key Vault.
     * 
     * @return the keyVaultId value.
     */
    public String keyVaultId() {
        return this.keyVaultId;
    }

    /**
     * Set the keyVaultId property: The resource ID of the Key Vault.
     * 
     * @param keyVaultId the keyVaultId value to set.
     * @return the IstioPluginCertificateAuthority object itself.
     */
    public IstioPluginCertificateAuthority withKeyVaultId(String keyVaultId) {
        this.keyVaultId = keyVaultId;
        return this;
    }

    /**
     * Get the certObjectName property: Intermediate certificate object name in Azure Key Vault.
     * 
     * @return the certObjectName value.
     */
    public String certObjectName() {
        return this.certObjectName;
    }

    /**
     * Set the certObjectName property: Intermediate certificate object name in Azure Key Vault.
     * 
     * @param certObjectName the certObjectName value to set.
     * @return the IstioPluginCertificateAuthority object itself.
     */
    public IstioPluginCertificateAuthority withCertObjectName(String certObjectName) {
        this.certObjectName = certObjectName;
        return this;
    }

    /**
     * Get the keyObjectName property: Intermediate certificate private key object name in Azure Key Vault.
     * 
     * @return the keyObjectName value.
     */
    public String keyObjectName() {
        return this.keyObjectName;
    }

    /**
     * Set the keyObjectName property: Intermediate certificate private key object name in Azure Key Vault.
     * 
     * @param keyObjectName the keyObjectName value to set.
     * @return the IstioPluginCertificateAuthority object itself.
     */
    public IstioPluginCertificateAuthority withKeyObjectName(String keyObjectName) {
        this.keyObjectName = keyObjectName;
        return this;
    }

    /**
     * Get the rootCertObjectName property: Root certificate object name in Azure Key Vault.
     * 
     * @return the rootCertObjectName value.
     */
    public String rootCertObjectName() {
        return this.rootCertObjectName;
    }

    /**
     * Set the rootCertObjectName property: Root certificate object name in Azure Key Vault.
     * 
     * @param rootCertObjectName the rootCertObjectName value to set.
     * @return the IstioPluginCertificateAuthority object itself.
     */
    public IstioPluginCertificateAuthority withRootCertObjectName(String rootCertObjectName) {
        this.rootCertObjectName = rootCertObjectName;
        return this;
    }

    /**
     * Get the certChainObjectName property: Certificate chain object name in Azure Key Vault.
     * 
     * @return the certChainObjectName value.
     */
    public String certChainObjectName() {
        return this.certChainObjectName;
    }

    /**
     * Set the certChainObjectName property: Certificate chain object name in Azure Key Vault.
     * 
     * @param certChainObjectName the certChainObjectName value to set.
     * @return the IstioPluginCertificateAuthority object itself.
     */
    public IstioPluginCertificateAuthority withCertChainObjectName(String certChainObjectName) {
        this.certChainObjectName = certChainObjectName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyVaultId", this.keyVaultId);
        jsonWriter.writeStringField("certObjectName", this.certObjectName);
        jsonWriter.writeStringField("keyObjectName", this.keyObjectName);
        jsonWriter.writeStringField("rootCertObjectName", this.rootCertObjectName);
        jsonWriter.writeStringField("certChainObjectName", this.certChainObjectName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IstioPluginCertificateAuthority from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IstioPluginCertificateAuthority if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IstioPluginCertificateAuthority.
     */
    public static IstioPluginCertificateAuthority fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IstioPluginCertificateAuthority deserializedIstioPluginCertificateAuthority
                = new IstioPluginCertificateAuthority();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyVaultId".equals(fieldName)) {
                    deserializedIstioPluginCertificateAuthority.keyVaultId = reader.getString();
                } else if ("certObjectName".equals(fieldName)) {
                    deserializedIstioPluginCertificateAuthority.certObjectName = reader.getString();
                } else if ("keyObjectName".equals(fieldName)) {
                    deserializedIstioPluginCertificateAuthority.keyObjectName = reader.getString();
                } else if ("rootCertObjectName".equals(fieldName)) {
                    deserializedIstioPluginCertificateAuthority.rootCertObjectName = reader.getString();
                } else if ("certChainObjectName".equals(fieldName)) {
                    deserializedIstioPluginCertificateAuthority.certChainObjectName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIstioPluginCertificateAuthority;
        });
    }
}
