// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Profile of the managed outbound IP resources of the managed cluster.
 */
@Fluent
public final class ManagedClusterManagedOutboundIpProfile
    implements JsonSerializable<ManagedClusterManagedOutboundIpProfile> {
    /*
     * The desired number of outbound IPs created/managed by Azure. Allowed values must be in the range of 1 to 16
     * (inclusive). The default value is 1.
     */
    private Integer count;

    /**
     * Creates an instance of ManagedClusterManagedOutboundIpProfile class.
     */
    public ManagedClusterManagedOutboundIpProfile() {
    }

    /**
     * Get the count property: The desired number of outbound IPs created/managed by Azure. Allowed values must be in
     * the range of 1 to 16 (inclusive). The default value is 1.
     * 
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count property: The desired number of outbound IPs created/managed by Azure. Allowed values must be in
     * the range of 1 to 16 (inclusive). The default value is 1.
     * 
     * @param count the count value to set.
     * @return the ManagedClusterManagedOutboundIpProfile object itself.
     */
    public ManagedClusterManagedOutboundIpProfile withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("count", this.count);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedClusterManagedOutboundIpProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedClusterManagedOutboundIpProfile if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedClusterManagedOutboundIpProfile.
     */
    public static ManagedClusterManagedOutboundIpProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterManagedOutboundIpProfile deserializedManagedClusterManagedOutboundIpProfile
                = new ManagedClusterManagedOutboundIpProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("count".equals(fieldName)) {
                    deserializedManagedClusterManagedOutboundIpProfile.count = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedClusterManagedOutboundIpProfile;
        });
    }
}
