// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019
 * when Kubernetes &lt;= 1.24 or Windows2022 when Kubernetes &gt;= 1.25 if OSType is Windows.
 */
public final class OSSku extends ExpandableStringEnum<OSSku> {
    /**
     * Static value Ubuntu for OSSku.
     */
    public static final OSSku UBUNTU = fromString("Ubuntu");

    /**
     * Static value AzureLinux for OSSku.
     */
    public static final OSSku AZURE_LINUX = fromString("AzureLinux");

    /**
     * Static value AzureLinux3 for OSSku.
     */
    public static final OSSku AZURE_LINUX3 = fromString("AzureLinux3");

    /**
     * Static value CBLMariner for OSSku.
     */
    public static final OSSku CBLMARINER = fromString("CBLMariner");

    /**
     * Static value Windows2019 for OSSku.
     */
    public static final OSSku WINDOWS2019 = fromString("Windows2019");

    /**
     * Static value Windows2022 for OSSku.
     */
    public static final OSSku WINDOWS2022 = fromString("Windows2022");

    /**
     * Static value Ubuntu2204 for OSSku.
     */
    public static final OSSku UBUNTU2204 = fromString("Ubuntu2204");

    /**
     * Creates a new instance of OSSku value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public OSSku() {
    }

    /**
     * Creates or finds a OSSku from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding OSSku.
     */
    public static OSSku fromString(String name) {
        return fromString(name, OSSku.class);
    }

    /**
     * Gets known OSSku values.
     * 
     * @return known OSSku values.
     */
    public static Collection<OSSku> values() {
        return values(OSSku.class);
    }
}
